/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.driver;

import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.io.CompressedFile;
import com.vividsolutions.jump.io.DriverProperties;
import com.vividsolutions.jump.io.IllegalParametersException;
import com.vividsolutions.jump.io.JMLReader;
import com.vividsolutions.jump.workbench.driver.AbstractInputDriver;
import com.vividsolutions.jump.workbench.driver.DriverManager;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.ui.AbstractDriverPanel;
import com.vividsolutions.jump.workbench.ui.BasicFileDriverPanel;
import com.vividsolutions.jump.workbench.ui.ErrorHandler;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.WorkbenchFileFilter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class JMLFileInputDriver
extends AbstractInputDriver {
    private BasicFileDriverPanel panel;
    private DriverProperties dp = new DriverProperties();

    @Override
    public String toString() {
        return "JCS GML";
    }

    @Override
    public AbstractDriverPanel getPanel() {
        return this.panel;
    }

    @Override
    public void initialize(DriverManager driverManager, ErrorHandler errorHandler) {
        super.initialize(driverManager, errorHandler);
        this.panel = new BasicFileDriverPanel(errorHandler);
        this.panel.setFileDescription("JCS GML");
        this.panel.setFileFilter(new WorkbenchFileFilter("JCS GML"));
        this.panel.setFileMustExist(true);
    }

    @Override
    public void input(LayerManager layerManager, String categoryName) throws FileNotFoundException, IOException, com.vividsolutions.jump.io.ParseException, ParseException, IllegalParametersException, Exception {
        File selectedFile = this.panel.getSelectedFile();
        JMLReader jmlReader = new JMLReader();
        String name = selectedFile.getAbsolutePath();
        String extension = name.substring(name.length() - 3);
        this.dp = new DriverProperties();
        if (extension.equalsIgnoreCase("zip")) {
            this.dp.set("CompressedFile", name);
            String internalName = CompressedFile.getInternalZipFnameByExtension(".jml", name);
            if (internalName == null) {
                internalName = CompressedFile.getInternalZipFnameByExtension(".gml", name);
            }
            if (internalName == null) {
                internalName = CompressedFile.getInternalZipFnameByExtension(".xml", name);
            }
            if (internalName == null) {
                throw new Exception("Couldnt find a .jml, .xml, or .gml file inside the .zip file: " + name);
            }
            this.dp.set("File", internalName);
        } else if (extension.equalsIgnoreCase(".gz")) {
            this.dp.set("CompressedFile", name);
            this.dp.set("File", name);
        } else {
            this.dp.set("File", name);
        }
        FeatureCollection featureCollection = jmlReader.read(this.dp);
        Layer layer = layerManager.addLayer(categoryName, GUIUtil.nameWithoutExtension(selectedFile), featureCollection);
    }
}

