/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.OKCancelPanel;
import com.vividsolutions.jump.workbench.ui.plugin.WKTDisplayHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class EnterWKTDialog
extends JDialog {
    private static final int THRESHOLD_WKT_LENGTH = 500;
    JPanel mainPanel = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    private ArrayList actionListeners = new ArrayList();
    JLabel descriptionLabel = new JLabel();
    private boolean syncing = false;
    private Timer annotationUpdateTimer = GUIUtil.createRestartableSingleEventTimer(500, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            EnterWKTDialog.this.updateAnnotations();
        }
    });
    private WKTDisplayHelper helper = new WKTDisplayHelper();
    private JPanel buttonPanel = new JPanel();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JButton formatButton = new JButton();
    private OKCancelPanel okCancelPanel = new OKCancelPanel();
    private JButton compressButton = new JButton();
    private JPanel fillerPanel = new JPanel();
    private JPanel centerPanel = new JPanel();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private GridBagLayout gridBagLayout3 = new GridBagLayout();
    private JScrollPane annotationScrollPane = new JScrollPane();
    private JTextArea annotationTextArea = new JTextArea();
    private JTextArea textArea = new JTextArea(){

        @Override
        public void setText(String t) {
            super.setText(t);
            this.setCaretPosition(0);
        }
    };
    private JScrollPane mainScrollPane = new JScrollPane();

    public EnterWKTDialog(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.textArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                EnterWKTDialog.this.queueAnnotationUpdate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                EnterWKTDialog.this.queueAnnotationUpdate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                EnterWKTDialog.this.queueAnnotationUpdate();
            }
        });
        this.mainScrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                EnterWKTDialog.this.syncScrollBars();
            }
        });
        this.annotationScrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                EnterWKTDialog.this.syncScrollBars();
            }
        });
    }

    public EnterWKTDialog() {
        this((Frame)null, "", true);
    }

    private void syncScrollBars() {
        if (this.syncing) {
            return;
        }
        this.syncing = true;
        try {
            this.annotationScrollPane.getVerticalScrollBar().setValue(Math.max(1, this.mainScrollPane.getVerticalScrollBar().getValue()));
        }
        finally {
            this.syncing = false;
        }
    }

    private void queueAnnotationUpdate() {
        if (this.textArea.getText().length() < 500) {
            this.updateAnnotations();
        } else {
            this.annotationUpdateTimer.restart();
        }
    }

    private void updateAnnotations() {
        if (this.textArea.getLineWrap()) {
            this.annotationTextArea.setText("");
        } else {
            this.annotationTextArea.setText(this.helper.annotate(this.textArea.getText()));
        }
    }

    public void setDescription(String d) {
        this.descriptionLabel.setText(d);
    }

    public void setEditable(boolean editable) {
        this.textArea.setEditable(editable);
        this.okCancelPanel.setCancelVisible(editable);
        this.textArea.setOpaque(editable);
    }

    public boolean wasOKPressed() {
        return this.okCancelPanel.wasOKPressed();
    }

    public void addActionListener(ActionListener l) {
        this.actionListeners.add(l);
    }

    void jbInit() throws Exception {
        this.formatButton.setToolTipText("Beautify the Well-Known Text");
        this.mainPanel.setLayout(this.borderLayout1);
        this.buttonPanel.setLayout(this.gridBagLayout1);
        this.formatButton.setText("Format");
        this.formatButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EnterWKTDialog.this.formatButton_actionPerformed(e);
            }
        });
        this.okCancelPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EnterWKTDialog.this.okCancelPanel_actionPerformed(e);
            }
        });
        this.compressButton.setText("Compress");
        this.compressButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EnterWKTDialog.this.compressButton_actionPerformed(e);
            }
        });
        this.fillerPanel.setLayout(this.gridBagLayout2);
        this.centerPanel.setLayout(this.gridBagLayout3);
        this.annotationScrollPane.setHorizontalScrollBarPolicy(31);
        this.annotationScrollPane.setVerticalScrollBarPolicy(21);
        this.annotationScrollPane.setBorder(null);
        this.annotationScrollPane.setPreferredSize(new Dimension(73, 21));
        this.annotationScrollPane.setMinimumSize(this.annotationScrollPane.getPreferredSize());
        this.annotationTextArea.setMargin(new Insets(0, 5, 0, 0));
        this.annotationTextArea.setBackground(Color.lightGray);
        this.annotationTextArea.setFont(new Font("Monospaced", 1, 12));
        this.annotationTextArea.setEditable(false);
        this.textArea.setWrapStyleWord(false);
        this.textArea.setLineWrap(false);
        this.mainScrollPane.setBorder(null);
        this.centerPanel.setBorder(BorderFactory.createEtchedBorder());
        this.getContentPane().add(this.mainPanel);
        this.mainPanel.add((Component)this.buttonPanel, "South");
        this.buttonPanel.add((Component)this.formatButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.getContentPane().add((Component)this.descriptionLabel, "North");
        this.buttonPanel.add((Component)this.okCancelPanel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonPanel.add((Component)this.compressButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.buttonPanel.add((Component)this.fillerPanel, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.centerPanel, "Center");
        this.centerPanel.add((Component)this.annotationScrollPane, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.centerPanel.add((Component)this.mainScrollPane, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.mainScrollPane.getViewport().add(this.textArea);
        this.annotationScrollPane.getViewport().add(this.annotationTextArea);
    }

    public String getText() {
        return this.textArea.getText();
    }

    public void setText(String text) {
        this.textArea.setText(this.helper.format(text));
    }

    void okCancelPanel_actionPerformed(ActionEvent e) {
        for (ActionListener l : this.actionListeners) {
            l.actionPerformed(e);
        }
    }

    void formatButton_actionPerformed(ActionEvent e) {
        this.textArea.setLineWrap(false);
        this.textArea.setText(this.helper.format(this.textArea.getText()));
    }

    public static void main(String[] args) throws Exception {
        System.out.println(new SimpleDateFormat().parse("2003-12-05"));
    }

    void compressButton_actionPerformed(ActionEvent e) {
        this.textArea.setLineWrap(true);
        this.textArea.setText(this.compress(this.textArea.getText()));
    }

    private String compress(String s) {
        StringBuffer buffer = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(s);
        while (tokenizer.hasMoreTokens()) {
            buffer.append(tokenizer.nextToken() + " ");
        }
        return buffer.toString().trim();
    }
}

