/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class GeometryEditor {
    private GeometryFactory factory = new GeometryFactory();

    public Geometry edit(Geometry geometry, GeometryEditorOperation operation) {
        if (geometry instanceof GeometryCollection) {
            return this.editGeometryCollection((GeometryCollection)geometry, operation);
        }
        if (geometry instanceof Polygon) {
            return this.editPolygon((Polygon)geometry, operation);
        }
        if (geometry instanceof Point) {
            return operation.edit(geometry);
        }
        if (geometry instanceof LineString) {
            return operation.edit(geometry);
        }
        Assert.shouldNeverReachHere((String)"Unsupported Geometry classes should be caught in the GeometryEditorOperation.");
        return null;
    }

    private Polygon editPolygon(Polygon polygon, GeometryEditorOperation operation) {
        Polygon newPolygon = (Polygon)operation.edit((Geometry)polygon);
        if (newPolygon.isEmpty()) {
            return newPolygon;
        }
        LinearRing shell = (LinearRing)this.edit((Geometry)newPolygon.getExteriorRing(), operation);
        if (shell.isEmpty()) {
            return this.factory.createPolygon(null, null);
        }
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
        for (int i = 0; i < newPolygon.getNumInteriorRing(); ++i) {
            LinearRing hole = (LinearRing)this.edit((Geometry)newPolygon.getInteriorRingN(i), operation);
            if (hole.isEmpty()) continue;
            holes.add(hole);
        }
        return this.factory.createPolygon(shell, holes.toArray(new LinearRing[0]));
    }

    private GeometryCollection editGeometryCollection(GeometryCollection collection, GeometryEditorOperation operation) {
        GeometryCollection newCollection = (GeometryCollection)operation.edit((Geometry)collection);
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        for (int i = 0; i < newCollection.getNumGeometries(); ++i) {
            Geometry geometry = this.edit(newCollection.getGeometryN(i), operation);
            if (geometry.isEmpty()) continue;
            geometries.add(geometry);
        }
        if (newCollection.getClass() == MultiPoint.class) {
            return this.factory.createMultiPoint(geometries.toArray(new Point[0]));
        }
        if (newCollection.getClass() == MultiLineString.class) {
            return this.factory.createMultiLineString(geometries.toArray(new LineString[0]));
        }
        if (newCollection.getClass() == MultiPolygon.class) {
            return this.factory.createMultiPolygon(geometries.toArray(new Polygon[0]));
        }
        return this.factory.createGeometryCollection(geometries.toArray(new Geometry[0]));
    }

    public Geometry removeRepeatedPoints(Geometry geometry) {
        if (geometry.isEmpty()) {
            return geometry;
        }
        return this.edit(geometry, new CoordinateOperation(){

            @Override
            public Coordinate[] edit(Coordinate[] coordinates, boolean linearRing) {
                return CoordinateArrays.removeRepeatedPoints((Coordinate[])coordinates);
            }
        });
    }

    public Geometry remove(Geometry g, final Geometry itemToRemove) {
        return this.edit(g, new GeometryEditorOperation(){

            @Override
            public Geometry edit(Geometry geometry) {
                if (geometry == itemToRemove) {
                    return GeometryEditor.this.createNullGeometry(geometry.getClass());
                }
                return geometry;
            }
        });
    }

    private Geometry createNullGeometry(Class geometryClass) {
        if (geometryClass == MultiPolygon.class) {
            return this.factory.createMultiPolygon(null);
        }
        if (geometryClass == MultiLineString.class) {
            return this.factory.createMultiLineString(null);
        }
        if (geometryClass == MultiPoint.class) {
            return this.factory.createMultiPoint((Coordinate[])null);
        }
        if (geometryClass == GeometryCollection.class) {
            return this.factory.createGeometryCollection(null);
        }
        if (geometryClass == Polygon.class) {
            return this.factory.createPolygon(null, null);
        }
        if (geometryClass == LinearRing.class) {
            return this.factory.createLinearRing((Coordinate[])null);
        }
        if (geometryClass == LineString.class) {
            return this.factory.createLineString((Coordinate[])null);
        }
        if (geometryClass == Point.class) {
            return this.factory.createPoint((Coordinate)null);
        }
        Assert.shouldNeverReachHere();
        return null;
    }

    public Geometry insertVertex(Geometry geometry, Coordinate target, Geometry ignoreSegmentsOutside) {
        LineString closestSegment = null;
        Point targetPoint = this.factory.createPoint(target);
        for (Coordinate[] coordinates : com.vividsolutions.jump.util.CoordinateArrays.toCoordinateArrays(geometry, false)) {
            if (coordinates.length < 2) continue;
            for (int j = 1; j < coordinates.length; ++j) {
                LineString candidate = this.factory.createLineString(new Coordinate[]{coordinates[j], coordinates[j - 1]});
                if (!candidate.intersects(ignoreSegmentsOutside)) continue;
                if (closestSegment == null) {
                    closestSegment = candidate;
                    continue;
                }
                if (!(candidate.distance((Geometry)targetPoint) < closestSegment.distance((Geometry)targetPoint))) continue;
                closestSegment = candidate;
            }
        }
        if (closestSegment == null) {
            return null;
        }
        return this.insertVertex(geometry, closestSegment.getCoordinateN(0), closestSegment.getCoordinateN(1), new LineSegment(closestSegment.getCoordinateN(0), closestSegment.getCoordinateN(1)).closestPoint(target));
    }

    public Geometry insertVertex(Geometry geometry, final Coordinate existing1, final Coordinate existing2, final Coordinate v) {
        if (geometry.isEmpty()) {
            return geometry;
        }
        return this.edit(geometry, new CoordinateOperation(){
            private boolean vertexInserted = false;

            @Override
            public Coordinate[] edit(Coordinate[] coordinates, boolean linearRing) {
                if (this.vertexInserted) {
                    return coordinates;
                }
                for (int i = 1; i < coordinates.length; ++i) {
                    if ((!coordinates[i - 1].equals((Object)existing1) || !coordinates[i].equals((Object)existing2)) && (!coordinates[i - 1].equals((Object)existing2) || !coordinates[i].equals((Object)existing1))) continue;
                    Coordinate[] newCoordinates = new Coordinate[coordinates.length + 1];
                    System.arraycopy(coordinates, 0, newCoordinates, 0, i);
                    newCoordinates[i] = v;
                    System.arraycopy(coordinates, i, newCoordinates, i + 1, coordinates.length - i);
                    this.vertexInserted = true;
                    return newCoordinates;
                }
                return coordinates;
            }
        });
    }

    public Geometry deleteVertices(Geometry geometry, final Collection vertices) {
        return this.edit(geometry, new CoordinateOperation(){

            @Override
            public Coordinate[] edit(Coordinate[] coordinates, boolean linearRing) {
                ArrayList<Coordinate> newCoordinates = new ArrayList<Coordinate>(Arrays.asList(coordinates));
                boolean firstCoordinateDeleted = false;
                int j = -1;
                Iterator i = newCoordinates.iterator();
                while (i.hasNext()) {
                    Coordinate c = (Coordinate)i.next();
                    ++j;
                    if (!GeometryEditor.this.containsReference(vertices, c)) continue;
                    i.remove();
                    if (j != 0) continue;
                    firstCoordinateDeleted = true;
                }
                if (linearRing && firstCoordinateDeleted) {
                    newCoordinates.remove(newCoordinates.size() - 1);
                }
                if (linearRing && firstCoordinateDeleted && !newCoordinates.isEmpty() && !newCoordinates.get(0).equals(newCoordinates.get(newCoordinates.size() - 1))) {
                    newCoordinates.add(new Coordinate((Coordinate)newCoordinates.get(0)));
                }
                return newCoordinates.toArray(new Coordinate[0]);
            }
        });
    }

    public boolean containsReference(Collection collection, Object o) {
        for (Object item : collection) {
            if (item != o) continue;
            return true;
        }
        return false;
    }

    private Coordinate[] atLeastNCoordinatesOrNothing(int n, Coordinate[] c) {
        return c.length >= n ? c : new Coordinate[]{};
    }

    private abstract class CoordinateOperation
    implements GeometryEditorOperation {
        private CoordinateOperation() {
        }

        @Override
        public Geometry edit(Geometry geometry) {
            if (geometry instanceof LinearRing) {
                return GeometryEditor.this.factory.createLinearRing(GeometryEditor.this.atLeastNCoordinatesOrNothing(4, this.edit(geometry.getCoordinates(), true)));
            }
            if (geometry instanceof LineString) {
                return GeometryEditor.this.factory.createLineString(GeometryEditor.this.atLeastNCoordinatesOrNothing(2, this.edit(geometry.getCoordinates(), false)));
            }
            if (geometry instanceof Point) {
                Coordinate[] newCoordinates = this.edit(geometry.getCoordinates(), false);
                Assert.isTrue((newCoordinates.length < 2 ? 1 : 0) != 0);
                return GeometryEditor.this.factory.createPoint(newCoordinates.length > 0 ? newCoordinates[0] : null);
            }
            return geometry;
        }

        public abstract Coordinate[] edit(Coordinate[] var1, boolean var2);
    }

    public static interface GeometryEditorOperation {
        public Geometry edit(Geometry var1);
    }
}

