/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.RecordPanel;
import com.vividsolutions.jump.workbench.ui.RecordPanelModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class HTMLPanel
extends JPanel
implements RecordPanelModel {
    private ArrayList history = new ArrayList();
    protected JButton okButton = new JButton();
    private RecordPanel recordPanel = new RecordPanel(this);
    private JPanel southPanel = new JPanel();
    private JScrollPane scrollPane = new JScrollPane();
    private JEditorPane editorPane = new JEditorPane();
    private int currentIndex = -1;
    private JPanel fillerPanel = new JPanel();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();

    public HTMLPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.okButton.setVisible(false);
    }

    public RecordPanel getRecordPanel() {
        return this.recordPanel;
    }

    @Override
    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public void addField(String label, String value) {
        this.addField(label, value, "");
    }

    private void setLatestDocument(String document) {
        this.history.set(this.history.size() - 1, document);
    }

    private String getLatestDocument() {
        return (String)this.history.get(this.history.size() - 1);
    }

    protected void setEditorPaneText() {
        final String document = (String)this.history.get(this.currentIndex);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HTMLPanel.this.editorPane.setText("<HTML>" + document + "</HTML>");
            }
        });
        this.scrollToTop();
    }

    public void append(String html) {
        this.setLatestDocument(this.getLatestDocument() + html);
        this.goToLatestDocument();
    }

    public void addText(String text) {
        this.append(GUIUtil.escapeHTML(text, false, true) + " <BR>\n");
    }

    public void addField(String label, String value, String units) {
        this.append("<B> " + label + " </B>" + value + " " + units + " <BR>\n");
    }

    public void addHeader(int level, String text) {
        this.append("<H" + level + "> " + GUIUtil.escapeHTML(text, false, false) + " </H" + level + ">\n");
    }

    public JButton getOKButton() {
        return this.okButton;
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.editorPane.setEditable(false);
        this.editorPane.setContentType("text/html");
        this.southPanel.setLayout(this.gridBagLayout1);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.okButton.setText("OK");
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)this.southPanel, "South");
        this.southPanel.add((Component)this.fillerPanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.southPanel.add((Component)this.recordPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.southPanel.add((Component)this.okButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.scrollPane.getViewport().add((Component)this.editorPane, null);
    }

    public void setRecordNavigationControlVisible(boolean visible) {
        this.southPanel.setVisible(visible);
    }

    public void scrollToTop() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HTMLPanel.this.editorPane.setCaretPosition(0);
            }
        });
    }

    private void goToLatestDocument() {
        this.setCurrentIndex(this.history.size() - 1);
    }

    public void createNewDocument() {
        this.history.add("");
        this.goToLatestDocument();
        this.recordPanel.updateAppearance();
    }

    @Override
    public void setCurrentIndex(int index) {
        this.currentIndex = index;
        this.setEditorPaneText();
    }

    @Override
    public int getRecordCount() {
        return this.history.size();
    }

    public Color getBackgroundColor() {
        return this.editorPane.getBackground();
    }

    public void setBackgroundColor(Color color) {
        this.editorPane.setBackground(color);
    }
}

