/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.workbench.model.CategoryEvent;
import com.vividsolutions.jump.workbench.model.FeatureEvent;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEvent;
import com.vividsolutions.jump.workbench.model.LayerListener;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.ui.LayerNameRenderer;
import com.vividsolutions.jump.workbench.ui.plugin.AddNewLayerPlugIn;
import java.awt.Color;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class LayerComboBox
extends JComboBox {
    private static final Layer DUMMY_LAYER = new Layer(" ", new Color(0, 0, 0, 0), AddNewLayerPlugIn.createBlankFeatureCollection(), new LayerManager());
    private LayerManager layerManager = new LayerManager();
    private LayerListener listener = new LayerListener(){

        @Override
        public void featuresChanged(FeatureEvent e) {
        }

        @Override
        public void layerChanged(LayerEvent e) {
            LayerComboBox.this.updateModel();
        }

        @Override
        public void categoryChanged(CategoryEvent e) {
        }
    };

    @Override
    public Object getSelectedItem() {
        return super.getSelectedItem() != DUMMY_LAYER ? super.getSelectedItem() : null;
    }

    public LayerComboBox() {
        super(new DefaultComboBoxModel());
        this.setRenderer(new LayerNameRenderer());
    }

    private DefaultComboBoxModel getMyModel() {
        return (DefaultComboBoxModel)this.getModel();
    }

    private void updateModel() {
        Layer selectedLayer = this.getSelectedLayer();
        this.getMyModel().removeAllElements();
        Iterator i = this.layerManager.iterator();
        while (i.hasNext()) {
            Layer layer = (Layer)i.next();
            this.getMyModel().addElement(layer);
        }
        if (this.getMyModel().getSize() == 0) {
            this.getMyModel().addElement(DUMMY_LAYER);
        }
        if (-1 != this.getMyModel().getIndexOf(selectedLayer)) {
            this.getMyModel().setSelectedItem(selectedLayer);
        }
    }

    public Layer getSelectedLayer() {
        return (Layer)this.getSelectedItem();
    }

    public void setLayerManager(LayerManager layerManager) {
        this.layerManager.removeLayerListener(this.listener);
        this.layerManager = layerManager;
        this.layerManager.addLayerListener(this.listener);
        this.updateModel();
    }

    public LayerManager getLayerManager() {
        return this.layerManager;
    }

    public void setSelectedLayer(Layer candidateLayer) {
        this.setSelectedItem(candidateLayer);
    }
}

