/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.WMSLayer;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerColorPanel;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.wms.MapLayerPanel;
import com.vividsolutions.jump.workbench.ui.renderer.RenderingManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.tree.TreeCellRenderer;

public class LayerNameRenderer
extends JPanel
implements ListCellRenderer,
TreeCellRenderer {
    private static final Color UNSELECTED_EDITABLE_FONT_COLOR = Color.red;
    private static final Color SELECTED_EDITABLE_FONT_COLOR = Color.yellow;
    protected JCheckBox checkBox = new JCheckBox();
    private LayerColorPanel colorPanel = new LayerColorPanel();
    GridBagLayout gridBagLayout = new GridBagLayout();
    protected JLabel label = new JLabel();
    private boolean indicatingEditability = false;
    private boolean indicatingProgress = false;
    private int progressIconSize = 13;
    private Icon[] progressIcons = new Icon[]{GUIUtil.resize(IconLoader.icon("ClockN.gif"), this.progressIconSize), GUIUtil.resize(IconLoader.icon("ClockNE.gif"), this.progressIconSize), GUIUtil.resize(IconLoader.icon("ClockE.gif"), this.progressIconSize), GUIUtil.resize(IconLoader.icon("ClockSE.gif"), this.progressIconSize), GUIUtil.resize(IconLoader.icon("ClockS.gif"), this.progressIconSize), GUIUtil.resize(IconLoader.icon("ClockSW.gif"), this.progressIconSize), GUIUtil.resize(IconLoader.icon("ClockW.gif"), this.progressIconSize), GUIUtil.resize(IconLoader.icon("ClockNW.gif"), this.progressIconSize)};
    private Icon clearProgressIcon = GUIUtil.resize(IconLoader.icon("Clear.gif"), this.progressIconSize);
    private String PROGRESS_ICON_KEY = "PROGRESS_ICON";
    private DefaultListCellRenderer defaultListCellRenderer = new DefaultListCellRenderer();
    private RenderingManager renderingManager;
    private JLabel progressIconLabel = new JLabel();
    private Font font = new JLabel().getFont();
    private Font editableFont = this.font.deriveFont(1);
    private JLabel wmsIconLabel = new JLabel(MapLayerPanel.ICON);

    public LayerNameRenderer() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setIndicatingEditability(boolean indicatingEditability) {
        this.indicatingEditability = indicatingEditability;
    }

    public void setIndicatingProgress(boolean indicatingProgress, RenderingManager renderingManager) {
        this.indicatingProgress = indicatingProgress;
        this.renderingManager = renderingManager;
    }

    public JLabel getLabel() {
        return this.label;
    }

    public Rectangle getCheckBoxBounds() {
        int i = this.gridBagLayout.getConstraints((Component)this.checkBox).gridx;
        int x = 0;
        for (int j = 0; j < i; ++j) {
            x += this.getColumnWidth(j);
        }
        return new Rectangle(x, 0, this.getColumnWidth(i), this.getRowHeight());
    }

    protected int getColumnWidth(int i) {
        this.validateTree();
        return this.gridBagLayout.getLayoutDimensions()[0][i];
    }

    protected int getRowHeight() {
        this.validateTree();
        return this.gridBagLayout.getLayoutDimensions()[1][0];
    }

    public void setCheckBoxVisible(boolean checkBoxVisible) {
        this.checkBox.setVisible(checkBoxVisible);
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.validate();
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value == null) {
            return this.defaultListCellRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
        Layerable layerable = (Layerable)value;
        this.label.setText(layerable.getName());
        this.setToolTipText(layerable.getName() + (layerable instanceof Layer && ((Layer)layerable).getDescription() != null && ((Layer)layerable).getDescription().trim().length() > 0 ? ": " + ((Layer)layerable).getDescription() : ""));
        if (isSelected) {
            this.label.setForeground(list.getSelectionForeground());
            this.label.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
            this.setBackground(list.getSelectionBackground());
        } else {
            this.label.setForeground(list.getForeground());
            this.label.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
            this.setBackground(list.getBackground());
        }
        this.colorPanel.setVisible(layerable instanceof Layer);
        this.checkBox.setSelected(layerable.isVisible());
        if (this.indicatingEditability && layerable instanceof Layer && ((Layer)layerable).isEditable()) {
            this.label.setFont(this.editableFont);
            this.label.setForeground(isSelected ? SELECTED_EDITABLE_FONT_COLOR : UNSELECTED_EDITABLE_FONT_COLOR);
        } else {
            this.label.setFont(this.font);
        }
        this.wmsIconLabel.setVisible(layerable instanceof WMSLayer);
        if (layerable instanceof WMSLayer && this.indicatingProgress && this.renderingManager.getRenderer(layerable) != null && this.renderingManager.getRenderer(layerable).isRendering()) {
            layerable.getBlackboard().put(this.PROGRESS_ICON_KEY, layerable.getBlackboard().get(this.PROGRESS_ICON_KEY, 0) + 1);
            if (layerable.getBlackboard().getInt(this.PROGRESS_ICON_KEY) > this.progressIcons.length - 1) {
                layerable.getBlackboard().put(this.PROGRESS_ICON_KEY, 0);
            }
            this.progressIconLabel.setIcon(this.progressIcons[layerable.getBlackboard().getInt(this.PROGRESS_ICON_KEY)]);
        } else {
            this.progressIconLabel.setIcon(this.clearProgressIcon);
        }
        Color backgroundColor = list.getBackground();
        Color selectionBackgroundColor = list.getSelectionBackground();
        if (layerable instanceof Layer) {
            Layer layer = (Layer)layerable;
            this.colorPanel.init(layer, isSelected, backgroundColor, selectionBackgroundColor);
        }
        return this;
    }

    private JList list(JTree tree) {
        JList list = new JList();
        list.setForeground(tree.getForeground());
        list.setBackground(tree.getBackground());
        list.setSelectionForeground(UIManager.getColor("Tree.selectionForeground"));
        list.setSelectionBackground(UIManager.getColor("Tree.selectionBackground"));
        return list;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Layerable layerable = (Layerable)value;
        this.getListCellRendererComponent(this.list(tree), layerable, -1, selected, hasFocus);
        if (selected) {
            this.label.setForeground(UIManager.getColor("Tree.selectionForeground"));
            this.label.setBackground(UIManager.getColor("Tree.selectionBackground"));
            this.setForeground(UIManager.getColor("Tree.selectionForeground"));
            this.setBackground(UIManager.getColor("Tree.selectionBackground"));
        } else {
            this.label.setForeground(tree.getForeground());
            this.label.setBackground(tree.getBackground());
            this.setForeground(tree.getForeground());
            this.setBackground(tree.getBackground());
        }
        if (this.indicatingEditability && layerable instanceof Layer && ((Layer)layerable).isEditable()) {
            this.label.setForeground(selected ? SELECTED_EDITABLE_FONT_COLOR : UNSELECTED_EDITABLE_FONT_COLOR);
        }
        return this;
    }

    void jbInit() throws Exception {
        this.checkBox.setVisible(false);
        this.setLayout(this.gridBagLayout);
        this.label.setOpaque(false);
        this.label.setText("Layer Name Goes Here");
        this.checkBox.setOpaque(false);
        this.add((Component)this.progressIconLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 2), 0, 0));
        this.add((Component)this.wmsIconLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 2), 0, 0));
        this.add((Component)this.colorPanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)this.checkBox, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.label, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
    }
}

