/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelContext;
import com.vividsolutions.jump.workbench.ui.renderer.LayerRenderer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class LayerPrinter {
    public BufferedImage print(Collection layers, Envelope envelope, int extentInPixels) throws Exception {
        Assert.isTrue((!layers.isEmpty() ? 1 : 0) != 0);
        final Throwable[] throwable = new Throwable[]{null};
        LayerViewPanel panel = new LayerViewPanel(((Layer)layers.iterator().next()).getLayerManager(), new LayerViewPanelContext(){

            @Override
            public void setStatusMessage(String message) {
            }

            @Override
            public void warnUser(String warning) {
            }

            @Override
            public void handleThrowable(Throwable t) {
                throwable[0] = t;
            }
        });
        panel.setSize(extentInPixels, extentInPixels);
        panel.getViewport().zoom(envelope);
        BufferedImage bufferedImage = new BufferedImage(panel.getWidth(), panel.getHeight(), 2);
        Graphics2D graphics = bufferedImage.createGraphics();
        this.paintBackground(graphics, extentInPixels);
        ArrayList layersReversed = new ArrayList(layers);
        Collections.reverse(layersReversed);
        for (Layer layer : layersReversed) {
            LayerRenderer renderer = new LayerRenderer(layer, panel);
            Runnable runnable = renderer.createRunnable();
            if (runnable != null) {
                runnable.run();
            }
            renderer.copyTo(graphics);
        }
        if (throwable[0] != null) {
            throw throwable[0] instanceof Exception ? (Exception)throwable[0] : new Exception(throwable[0].getMessage());
        }
        return bufferedImage;
    }

    private void paintBackground(Graphics2D graphics, int extent) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, extent, extent);
    }
}

