/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.ColumnBasedTableModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.TableModelEvent;

public class SchemaTableModel
extends ColumnBasedTableModel {
    private ArrayList fields = new ArrayList();
    public static final String FIELD_NAME_COLUMN_NAME = "Field Name";
    public static final String DATA_TYPE_COLUMN_NAME = "Data Type";
    private static final int BLANK_ROWS = 30;
    private Layer layer;

    @Override
    public int getRowCount() {
        return this.fields.size();
    }

    public List getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public Field get(int row) {
        return (Field)this.fields.get(row);
    }

    public SchemaTableModel(Layer layer) {
        this.layer = layer;
        for (int i = 0; i < layer.getFeatureCollectionWrapper().getFeatureSchema().getAttributeCount(); ++i) {
            Field field = new Field();
            field.setName(layer.getFeatureCollectionWrapper().getFeatureSchema().getAttributeName(i));
            field.setType(layer.getFeatureCollectionWrapper().getFeatureSchema().getAttributeType(i));
            field.setOriginalIndex(i);
            this.fields.add(field);
        }
        this.addBlankRows();
        ArrayList<ColumnBasedTableModel.Column> columns = new ArrayList<ColumnBasedTableModel.Column>();
        columns.add(new ColumnBasedTableModel.Column(FIELD_NAME_COLUMN_NAME, String.class){

            @Override
            public Object getValueAt(int row) {
                return SchemaTableModel.this.get(row).getName();
            }

            @Override
            public void setValueAt(Object value, int row) {
                if ((value == null || ((String)value).length() == 0) && SchemaTableModel.this.get(row).getType() == null) {
                    return;
                }
                SchemaTableModel.this.get(row).setName(((String)value).trim());
                if (SchemaTableModel.this.get(row).getType() == null) {
                    SchemaTableModel.this.get(row).setType(AttributeType.STRING);
                }
                SchemaTableModel.this.fieldsModified(new int[]{row});
            }
        });
        columns.add(new ColumnBasedTableModel.Column(DATA_TYPE_COLUMN_NAME, AttributeType.class){

            @Override
            public Object getValueAt(int row) {
                return SchemaTableModel.this.get(row).getType();
            }

            @Override
            public void setValueAt(Object value, int row) {
                if (value == null) {
                    return;
                }
                SchemaTableModel.this.get(row).setType((AttributeType)value);
                if (SchemaTableModel.this.get(row).getName() == null) {
                    SchemaTableModel.this.get(row).setName(SchemaTableModel.this.createName());
                }
                SchemaTableModel.this.fieldsModified(new int[]{row});
            }
        });
        this.setColumns(columns);
    }

    private void fieldsModified(int[] rows) {
        for (int i = 0; i < rows.length; ++i) {
            this.fireTableChanged(new TableModelEvent(this, rows[i]));
            this.addBlankRowsIfNecessary(rows[i]);
        }
    }

    private String createName() {
        int i = 1;
        while (this.hasFieldNamed("Field" + i)) {
            ++i;
        }
        return "Field" + i;
    }

    private boolean hasFieldNamed(String name) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (this.get(i).getName() == null || !this.get(i).getName().equalsIgnoreCase(name.trim())) continue;
            return true;
        }
        return false;
    }

    private void addBlankRowsIfNecessary(int indexOfModifiedField) {
        if (this.fields.size() - indexOfModifiedField < 30) {
            int firstRow = this.fields.size();
            this.addBlankRows();
            this.fireTableChanged(new TableModelEvent(this, firstRow, this.fields.size() - 1));
        }
    }

    private void addBlankRows() {
        for (int i = 0; i < 30; ++i) {
            this.fields.add(new Field());
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this.layer.isEditable();
    }

    private void removeField(int row) {
        this.removeFields(new int[]{row});
    }

    public void removeFields(int[] rows) {
        for (Integer row : CollectionUtil.reverseSortedSet(rows)) {
            this.fields.remove(row);
            this.fieldsModified(rows);
            this.fireTableChanged(new TableModelEvent(this, row, row, -1, -1));
        }
    }

    public void removeBlankRows() {
        Iterator i = this.fields.iterator();
        while (i.hasNext()) {
            Field field = (Field)i.next();
            if (field.getName() != null) continue;
            i.remove();
        }
    }

    public void insertBlankRow(int location) {
        this.insertField(location, new Field());
    }

    private void insertField(int location, Field field) {
        this.fields.add(location, field);
        this.fireTableChanged(new TableModelEvent(this, location, location, -1, 1));
        this.fieldsModified(new int[]{location});
    }

    public void move(Collection fieldsToMove, int displacement) {
        for (Field field : fieldsToMove) {
            int index = this.fields.indexOf(field);
            this.removeField(index);
            this.insertField(index + displacement, field);
        }
    }

    public int indexOf(Field field) {
        return this.fields.indexOf(field);
    }

    public static class Field {
        private String name = null;
        private AttributeType type = null;
        private int originalIndex = -1;

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setType(AttributeType type) {
            this.type = type;
        }

        public AttributeType getType() {
            return this.type;
        }

        public void setOriginalIndex(int originalIndex) {
            this.originalIndex = originalIndex;
        }

        public int getOriginalIndex() {
            return this.originalIndex;
        }
    }
}

