/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool;

import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Icon;

public abstract class CompositeTool
implements CursorTool {
    protected ArrayList cursorTools = new ArrayList();
    private LayerViewPanel panel = null;

    public CompositeTool(CursorTool[] cursorTools) {
        this.cursorTools = new ArrayList<CursorTool>(Arrays.asList(cursorTools));
    }

    @Override
    public void deactivate() {
        for (CursorTool tool : this.cursorTools) {
            tool.deactivate();
        }
    }

    @Override
    public Cursor getCursor() {
        for (CursorTool cursorTool : this.cursorTools) {
            if (cursorTool.getCursor() == Cursor.getDefaultCursor()) continue;
            return cursorTool.getCursor();
        }
        return Cursor.getDefaultCursor();
    }

    @Override
    public boolean isRightMouseButtonUsed() {
        for (CursorTool cursorTool : this.cursorTools) {
            if (!cursorTool.isRightMouseButtonUsed()) continue;
            return true;
        }
        return false;
    }

    protected CursorTool firstCursorTool() {
        return (CursorTool)this.cursorTools.get(0);
    }

    @Override
    public void activate(LayerViewPanel layerViewPanel) {
        this.panel = layerViewPanel;
        for (CursorTool tool : this.cursorTools) {
            tool.activate(layerViewPanel);
        }
    }

    public CompositeTool add(CursorTool tool) {
        this.cursorTools.add(tool);
        return this;
    }

    @Override
    public void cancelGesture() {
        for (CursorTool tool : this.cursorTools) {
            tool.cancelGesture();
        }
    }

    @Override
    public Icon getIcon() {
        for (CursorTool tool : this.cursorTools) {
            if (tool.getIcon() == null) continue;
            return tool.getIcon();
        }
        return null;
    }

    protected String getName(String delimiter) {
        String name = "";
        for (int i = 0; i < this.cursorTools.size(); ++i) {
            if (i > 0) {
                name = name + " " + delimiter + " ";
            }
            name = name + ((CursorTool)this.cursorTools.get(i)).getName();
        }
        return name;
    }

    @Override
    public boolean isGestureInProgress() {
        for (CursorTool tool : this.cursorTools) {
            if (!tool.isGestureInProgress()) continue;
            return true;
        }
        return false;
    }

    public LayerViewPanel getPanel() {
        return this.panel;
    }
}

