/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.util.java2xml.Java2XML;
import com.vividsolutions.jump.util.java2xml.XML2Java;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;

public class PersistentBlackboardPlugIn
extends AbstractPlugIn {
    private static final String FILENAME = "workbench-state.xml";
    private static final String BLACKBOARD_KEY = PersistentBlackboardPlugIn.class.getName() + " - BLACKBOARD";

    public static Blackboard get(WorkbenchContext context) {
        return (Blackboard)context.getBlackboard().get(BLACKBOARD_KEY, new Blackboard());
    }

    @Override
    public void initialize(final PlugInContext context) throws Exception {
        this.restoreState(context.getWorkbenchContext());
        context.getWorkbenchFrame().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                PersistentBlackboardPlugIn.this.saveState(context.getWorkbenchContext());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreState(WorkbenchContext workbenchContext) {
        try (FileReader fileReader = new FileReader(FILENAME);
             BufferedReader bufferedReader = new BufferedReader(fileReader);){
            PersistentBlackboardPlugIn.get(workbenchContext).putAll(((Blackboard)new XML2Java().read(bufferedReader, Blackboard.class)).getProperties());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveState(WorkbenchContext workbenchContext) {
        try (FileWriter fileWriter = new FileWriter(FILENAME, false);
             BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);){
            new Java2XML().write((Object)PersistentBlackboardPlugIn.get(workbenchContext), "workbench-state", bufferedWriter);
            bufferedWriter.flush();
            fileWriter.flush();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }
}

