/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.plugin.ExportImagePlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class SaveImageAsPlugIn
extends ExportImagePlugIn {
    private List myFileFilters = Arrays.asList(this.createFileFilter("PNG - Portable Network Graphics", "png", 2), this.createFileFilter("JPEG - Joint Photographic Experts Group", "jpg", 1));
    private JFileChooser fileChooser = null;
    private WorkbenchContext workbenchContext;
    private static final String FORMAT_KEY = "FORMAT";
    private static final String LAST_FILENAME_KEY = "LAST FILENAME";

    private JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new GUIUtil.FileChooserWithOverwritePrompting(){

                @Override
                protected File selectedFile() {
                    return new File(SaveImageAsPlugIn.this.addExtension(super.selectedFile().getPath(), ((MyFileFilter)this.getFileFilter()).getFormat()));
                }
            };
            this.fileChooser.setDialogTitle("Save Image");
            GUIUtil.removeChoosableFileFilters(this.fileChooser);
            HashMap<String, MyFileFilter> formatToFileFilterMap = new HashMap<String, MyFileFilter>();
            for (MyFileFilter fileFilter : this.myFileFilters) {
                this.fileChooser.addChoosableFileFilter(fileFilter);
                formatToFileFilterMap.put(fileFilter.getFormat(), fileFilter);
            }
            String lastFilename = (String)PersistentBlackboardPlugIn.get(this.workbenchContext).get(LAST_FILENAME_KEY);
            if (lastFilename != null) {
                this.fileChooser.setSelectedFile(new File(lastFilename));
            }
            this.fileChooser.setFileFilter((FileFilter)formatToFileFilterMap.get(PersistentBlackboardPlugIn.get(this.workbenchContext).get(FORMAT_KEY, "png")));
        }
        return this.fileChooser;
    }

    private MyFileFilter createFileFilter(String description, String format, int bufferedmageType) {
        return new MyFileFilter(description, format);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.workbenchContext = context.getWorkbenchContext();
        if (0 != this.getFileChooser().showSaveDialog(context.getWorkbenchFrame())) {
            return false;
        }
        MyFileFilter fileFilter = (MyFileFilter)this.getFileChooser().getFileFilter();
        BufferedImage image = this.image(context.getLayerViewPanel());
        String filename = this.addExtension(this.getFileChooser().getSelectedFile().getPath(), fileFilter.getFormat());
        this.save(image, fileFilter.getFormat(), new File(filename));
        PersistentBlackboardPlugIn.get(this.workbenchContext).put(FORMAT_KEY, fileFilter.getFormat());
        PersistentBlackboardPlugIn.get(this.workbenchContext).put(LAST_FILENAME_KEY, filename);
        return true;
    }

    private void save(RenderedImage image, String format, File file) throws IOException {
        boolean writerFound = ImageIO.write(image, format, file);
        Assert.isTrue((boolean)writerFound, (String)("Can't find writer for image format '" + format + "'"));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return !ExportImagePlugIn.java14OrNewer() ? "This feature requires Java 1.4 or newer" : null;
            }
        });
    }

    private String addExtension(String path, String extension) {
        if (path.toUpperCase().endsWith(extension.toUpperCase())) {
            return path;
        }
        if (path.endsWith(".")) {
            return path + extension;
        }
        return path + "." + extension;
    }

    private static class MyFileFilter
    extends FileFilter {
        private FileFilter fileFilter;
        private String format;

        public MyFileFilter(String description, String format) {
            this.fileFilter = GUIUtil.createFileFilter(description, new String[]{format});
            this.format = format;
        }

        @Override
        public boolean accept(File f) {
            return this.fileFilter.accept(f);
        }

        @Override
        public String getDescription() {
            return this.fileFilter.getDescription();
        }

        public String getFormat() {
            return this.format;
        }
    }
}

