/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.plugin.AbstractSaveProjectPlugIn;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class SaveProjectAsPlugIn
extends AbstractSaveProjectPlugIn {
    public static final FileFilter JUMP_PROJECT_FILE_FILTER = GUIUtil.createFileFilter("JUMP Task Files", new String[]{"jmp", "jcs"});
    private JFileChooser fileChooser;

    @Override
    public void initialize(PlugInContext context) throws Exception {
        this.fileChooser = GUIUtil.createJFileChooserWithOverwritePrompting();
        this.fileChooser.setDialogTitle("Save Task");
        GUIUtil.removeChoosableFileFilters(this.fileChooser);
        this.fileChooser.addChoosableFileFilter(JUMP_PROJECT_FILE_FILTER);
        this.fileChooser.addChoosableFileFilter(GUIUtil.ALL_FILES_FILTER);
        this.fileChooser.setFileFilter(JUMP_PROJECT_FILE_FILTER);
    }

    @Override
    public String getName() {
        return "Save Task As";
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        if (context.getTask().getProjectFile() != null) {
            this.fileChooser.setSelectedFile(context.getTask().getProjectFile());
        }
        if (0 != this.fileChooser.showSaveDialog(context.getWorkbenchFrame())) {
            return false;
        }
        File file = this.fileChooser.getSelectedFile();
        if (GUIUtil.getExtension(file) == "") {
            String path = file.getAbsolutePath();
            if (!path.endsWith(".")) {
                path = path + ".";
            }
            path = path + "jmp";
            file = new File(path);
        }
        this.save(context.getTask(), file, context.getWorkbenchFrame());
        return true;
    }
}

