/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.util.FileUtil;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.HTMLFrame;
import java.io.IOException;
import java.io.InputStream;

public class ShortcutKeysPlugIn
extends AbstractPlugIn {
    private static String html = null;

    private HTMLFrame frame(WorkbenchContext context) {
        String key = this.getClass().getName() + " - Frame";
        if (context.getWorkbench().getBlackboard().get(key) == null) {
            HTMLFrame frame = new HTMLFrame(context.getWorkbench().getFrame());
            frame.setRecordNavigationControlVisible(false);
            frame.createNewDocument();
            try {
                this.append(frame);
            }
            catch (IOException e) {
                Assert.shouldNeverReachHere();
            }
            frame.setTitle("Shortcut Keys");
            frame.setSize(420, 290);
            context.getWorkbench().getBlackboard().put(key, frame);
        }
        return (HTMLFrame)context.getWorkbench().getBlackboard().get(key);
    }

    public static String html() throws IOException {
        if (html == null) {
            html = "";
            try (InputStream inputStream = ShortcutKeysPlugIn.class.getResourceAsStream("KeyboardPlugIn.html");){
                for (String line : FileUtil.getContents(inputStream)) {
                    html = html + line;
                }
            }
        }
        return html;
    }

    private void append(HTMLFrame frame) throws IOException {
        frame.append(this.removeHTMLTags(ShortcutKeysPlugIn.html()));
    }

    private String removeHTMLTags(String s) {
        return StringUtil.replaceAll(StringUtil.replaceAll(s, "<html>", ""), "</html>", "");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.frame(context.getWorkbenchContext()).surface();
        return true;
    }
}

