/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.qa.ValidationError;
import com.vividsolutions.jump.qa.Validator;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.CollectionMap;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.renderer.style.RingVertexStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.VertexStyle;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class ValidateSelectedLayersPlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    private static final String CHECK_BASIC_TOPOLOGY = "Check basic topology";
    private static final String CHECK_POLYGON_ORIENTATION = "Check Polygon orientation";
    private static final String CHECK_LINESTRINGS_SIMPLE = "Check that LineStrings are simple";
    private static final String CHECK_POLYGONS_HAVE_NO_HOLES = "Disallow Polygons & MultiPolygons with holes";
    private static final String CHECK_NO_REPEATED_CONSECUTIVE_POINTS = "Disallow repeated consecutive points";
    private static final String CHECK_MIN_SEGMENT_LENGTH = "Check minimum segment length";
    private static final String CHECK_MIN_ANGLE = "Check minimum angle";
    private static final String MIN_SEGMENT_LENGTH = "Minimum segment length";
    private static final String MIN_ANGLE = "Minimum angle (in degrees)";
    private static final String MIN_POLYGON_AREA = "Minimum polygon area";
    private static final String CHECK_MIN_POLYGON_AREA = "Check minimum polygon area";
    private static final String DISALLOW_POINTS = "Disallow Points";
    private static final String DISALLOW_LINESTRINGS = "Disallow Linestrings";
    private static final String DISALLOW_POLYGONS = "Disallow Polygons";
    private static final String DISALLOW_MULTIPOINTS = "Disallow MultiPoints";
    private static final String DISALLOW_MULTILINESTRINGS = "Disallow MultiLineStrings";
    private static final String DISALLOW_MULTIPOLYGONS = "Disallow MultiPolygons";
    private static final String DISALLOW_GEOMETRYCOLLECTIONS = "Disallow GeometryCollections";
    private static final String ERROR = "ERROR";
    private static final String SOURCE_FID = "SOURCE_FID";
    private static final String GEOMETRY = "GEOMETRY";
    private MultiInputDialog dialog;
    private FeatureSchema schema;
    private GeometryFactory geometryFactory = new GeometryFactory();
    private Color GOLD = new Color(255, 192, 0, 150);
    private Validator validator;

    public ValidateSelectedLayersPlugIn() {
        this.initFeatureSchema();
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.validator = this.prompt(context);
        return this.validator != null;
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        Layer[] selectedLayers = context.getSelectedLayers();
        context.getOutputFrame().createNewDocument();
        context.getOutputFrame().addHeader(1, "Validation Errors");
        for (int i = 0; i < selectedLayers.length && !monitor.isCancelRequested(); ++i) {
            this.validate(selectedLayers[i], this.validator, context, monitor);
        }
    }

    private void initFeatureSchema() {
        this.schema = new FeatureSchema();
        this.schema.addAttribute(ERROR, AttributeType.STRING);
        this.schema.addAttribute(SOURCE_FID, AttributeType.INTEGER);
        this.schema.addAttribute(GEOMETRY, AttributeType.GEOMETRY);
    }

    private Validator prompt(PlugInContext context) {
        if (this.dialog == null) {
            this.initDialog(context);
        }
        this.dialog.setVisible(true);
        if (!this.dialog.wasOKPressed()) {
            return null;
        }
        Validator validator = new Validator();
        validator.setCheckingBasicTopology(this.dialog.getBoolean(CHECK_BASIC_TOPOLOGY));
        validator.setCheckingNoRepeatedConsecutivePoints(this.dialog.getBoolean(CHECK_NO_REPEATED_CONSECUTIVE_POINTS));
        validator.setCheckingLineStringsSimple(this.dialog.getBoolean(CHECK_LINESTRINGS_SIMPLE));
        validator.setCheckingPolygonOrientation(this.dialog.getBoolean(CHECK_POLYGON_ORIENTATION));
        validator.setCheckingNoHoles(this.dialog.getBoolean(CHECK_POLYGONS_HAVE_NO_HOLES));
        validator.setCheckingMinSegmentLength(this.dialog.getBoolean(CHECK_MIN_SEGMENT_LENGTH));
        validator.setCheckingMinAngle(this.dialog.getBoolean(CHECK_MIN_ANGLE));
        validator.setCheckingMinPolygonArea(this.dialog.getBoolean(CHECK_MIN_POLYGON_AREA));
        validator.setMinSegmentLength(this.dialog.getDouble(MIN_SEGMENT_LENGTH));
        validator.setMinAngle(this.dialog.getDouble(MIN_ANGLE));
        validator.setMinPolygonArea(this.dialog.getDouble(MIN_POLYGON_AREA));
        ArrayList<Class<GeometryCollection>> disallowedGeometryClasses = new ArrayList<Class<GeometryCollection>>();
        if (this.dialog.getBoolean(DISALLOW_POINTS)) {
            disallowedGeometryClasses.add(Point.class);
        }
        if (this.dialog.getBoolean(DISALLOW_LINESTRINGS)) {
            disallowedGeometryClasses.add(LineString.class);
        }
        if (this.dialog.getBoolean(DISALLOW_POLYGONS)) {
            disallowedGeometryClasses.add(Polygon.class);
        }
        if (this.dialog.getBoolean(DISALLOW_MULTIPOINTS)) {
            disallowedGeometryClasses.add(MultiPoint.class);
        }
        if (this.dialog.getBoolean(DISALLOW_MULTILINESTRINGS)) {
            disallowedGeometryClasses.add(MultiLineString.class);
        }
        if (this.dialog.getBoolean(DISALLOW_MULTIPOLYGONS)) {
            disallowedGeometryClasses.add(MultiPolygon.class);
        }
        if (this.dialog.getBoolean(DISALLOW_GEOMETRYCOLLECTIONS)) {
            disallowedGeometryClasses.add(GeometryCollection.class);
        }
        validator.setDisallowedGeometryClasses(disallowedGeometryClasses);
        return validator;
    }

    private void validate(Layer layer, Validator validator, PlugInContext context, TaskMonitor monitor) {
        List validationErrors = validator.validate(layer.getFeatureCollectionWrapper().getFeatures(), monitor);
        if (!validationErrors.isEmpty()) {
            this.addLayer(this.toLayer("Error Locations - " + layer.getName(), this.toLocationFeatures(validationErrors, layer), layer, true, context), context);
            this.addLayer(this.toLayer("Bad Features - " + layer.getName(), this.toFeatures(validationErrors, layer), layer, false, context), context);
        }
        this.outputSummary(context, layer, validationErrors);
    }

    private void outputSummary(PlugInContext context, Layer layer, List validationErrors) {
        context.getOutputFrame().addHeader(2, "Layer: " + layer.getName());
        if (validationErrors.isEmpty()) {
            context.getOutputFrame().addText("No validation errors");
            return;
        }
        CollectionMap descriptionToErrorMap = new CollectionMap();
        for (ValidationError error : validationErrors) {
            descriptionToErrorMap.addItem(error.getMessage(), error);
        }
        for (String message : descriptionToErrorMap.keySet()) {
            context.getOutputFrame().addField(message + ":", descriptionToErrorMap.getItems(message).size() + "");
        }
    }

    private List toFeatures(List validationErrors, Layer sourceLayer) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (ValidationError error : validationErrors) {
            features.add(this.toFeature(error, sourceLayer, (Geometry)error.getFeature().getGeometry().clone()));
        }
        return features;
    }

    private List toLocationFeatures(List validationErrors, Layer sourceLayer) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (ValidationError error : validationErrors) {
            Point geometry = this.geometryFactory.createPoint(error.getLocation());
            features.add(this.toFeature(error, sourceLayer, (Geometry)geometry));
        }
        return features;
    }

    private Feature toFeature(ValidationError error, Layer sourceLayer, Geometry geometry) {
        BasicFeature ringFeature = new BasicFeature(this.schema);
        ringFeature.setAttribute(SOURCE_FID, (Object)new Integer(error.getFeature().getID()));
        ringFeature.setAttribute(ERROR, (Object)error.getMessage());
        ringFeature.setGeometry(geometry);
        return ringFeature;
    }

    private void addLayer(Layer errorLayer, PlugInContext context) {
        context.getLayerManager().addLayer("QA", errorLayer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Layer toLayer(String name, List features, Layer sourceLayer, boolean ringVertices, PlugInContext context) {
        boolean firingEvents = context.getLayerManager().isFiringEvents();
        context.getLayerManager().setFiringEvents(false);
        try {
            FeatureDataset errorFeatureCollection = new FeatureDataset(features, this.schema);
            Layer errorLayer = new Layer(name, this.GOLD, errorFeatureCollection, context.getLayerManager());
            if (ringVertices) {
                errorLayer.getBasicStyle().setEnabled(false);
                this.changeVertexToRing(errorLayer);
            }
            this.showVertices(errorLayer);
            Layer layer = errorLayer;
            return layer;
        }
        finally {
            context.getLayerManager().setFiringEvents(firingEvents);
        }
    }

    private void changeVertexToRing(Layer errorLayer) {
        boolean firingEvents = errorLayer.getLayerManager().isFiringEvents();
        errorLayer.getLayerManager().setFiringEvents(false);
        try {
            errorLayer.removeStyle(errorLayer.getStyle(VertexStyle.class));
            errorLayer.addStyle(new RingVertexStyle());
            errorLayer.getBasicStyle().setLineWidth(5);
        }
        finally {
            errorLayer.getLayerManager().setFiringEvents(firingEvents);
        }
        errorLayer.fireAppearanceChanged();
    }

    private void showVertices(Layer errorLayer) {
        errorLayer.getVertexStyle().setEnabled(true);
        errorLayer.fireAppearanceChanged();
    }

    private void initDialog(PlugInContext context) {
        this.dialog = new MultiInputDialog(context.getWorkbenchFrame(), "Validate Selected Layers", true);
        this.dialog.setSideBarImage(IconLoader.icon("Validate.gif"));
        this.dialog.setSideBarDescription("Tests layers against various criteria, including polygon orientation, and minimum segment length");
        this.dialog.addLabel("<HTML><B>GEOMETRY METRICS VALIDATION</B></HTML>");
        this.dialog.addSeparator();
        this.dialog.addCheckBox(CHECK_BASIC_TOPOLOGY, true, "Test");
        this.dialog.addCheckBox(CHECK_NO_REPEATED_CONSECUTIVE_POINTS, false);
        this.dialog.addCheckBox(CHECK_POLYGON_ORIENTATION, false, "Check that polygon shells are oriented clockwise and holes counterclockwise");
        this.dialog.addCheckBox(CHECK_MIN_SEGMENT_LENGTH, false);
        this.dialog.addPositiveDoubleField(MIN_SEGMENT_LENGTH, 0.001, 5);
        this.dialog.addCheckBox(CHECK_MIN_ANGLE, false);
        this.dialog.addPositiveDoubleField(MIN_ANGLE, 1.0, 5);
        this.dialog.addCheckBox(CHECK_MIN_POLYGON_AREA, false);
        this.dialog.addPositiveDoubleField(MIN_POLYGON_AREA, 0.001, 5);
        this.dialog.addCheckBox(CHECK_LINESTRINGS_SIMPLE, false, "Check that LineStrings are simple (i.e. do not self-intersect)");
        this.dialog.startNewColumn();
        this.dialog.addLabel("<HTML><B>GEOMETRY TYPES VALIDATION</B></HTML>");
        this.dialog.addSeparator();
        this.dialog.addCheckBox(DISALLOW_POINTS, false);
        this.dialog.addCheckBox(DISALLOW_LINESTRINGS, false);
        this.dialog.addCheckBox(DISALLOW_POLYGONS, false);
        this.dialog.addCheckBox(DISALLOW_MULTIPOINTS, false);
        this.dialog.addCheckBox(DISALLOW_MULTILINESTRINGS, false);
        this.dialog.addCheckBox(DISALLOW_MULTIPOLYGONS, false);
        this.dialog.addCheckBox(CHECK_POLYGONS_HAVE_NO_HOLES, false);
        this.dialog.addCheckBox(DISALLOW_GEOMETRYCOLLECTIONS, false, "Geometry-collection subtypes (like multi-points) are not disallowed");
        GUIUtil.centreOnWindow(this.dialog);
    }
}

