/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jts.algorithm.PointLocator;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.WKTWriter;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.util.Fmt;
import com.vividsolutions.jump.workbench.model.FenceLayerFinder;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.TextFrame;
import com.vividsolutions.jump.workbench.ui.plugin.WKTDisplayHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class VerticesInFencePlugIn
extends AbstractPlugIn {
    private WKTWriter wktWriter = new WKTWriter();
    private GeometryFactory factory = new GeometryFactory();
    private WKTDisplayHelper helper = new WKTDisplayHelper();

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        TextFrame textFrame = new TextFrame(context.getWorkbenchFrame());
        textFrame.setTitle("Vertices In Fence");
        textFrame.clear();
        textFrame.setText(this.description(context));
        textFrame.setSize(550, 300);
        context.getWorkbenchFrame().addInternalFrame(textFrame);
        return true;
    }

    private String description(PlugInContext context) {
        FenceLayerFinder fenceLayerFinder = new FenceLayerFinder(context);
        StringBuffer description = new StringBuffer();
        description.append("<html><body>");
        Iterator i = context.getLayerManager().iterator();
        while (i.hasNext()) {
            Layer layer = (Layer)i.next();
            if (!layer.isVisible() || layer == fenceLayerFinder.getLayer()) continue;
            description.append(this.description(layer, context));
        }
        description.append("</body></html>");
        return description.toString();
    }

    public static Collection verticesInFence(Collection geometries, Geometry fence, boolean skipClosingVertex) {
        ArrayList verticesInFence = new ArrayList();
        for (Geometry geometry : geometries) {
            verticesInFence.addAll(VerticesInFencePlugIn.verticesInFence(geometry, fence, skipClosingVertex).getCoordinates());
        }
        return verticesInFence;
    }

    public static VerticesInFence verticesInFence(Geometry geometry, final Geometry fence, final boolean skipClosingVertex) {
        final ArrayList coordinates = new ArrayList();
        final ArrayList indices = new ArrayList();
        final PointLocator pointLocator = new PointLocator();
        final IntWrapper index = new IntWrapper(-1);
        geometry.apply(new GeometryComponentFilter(){

            public void filter(Geometry geometry) {
                if (geometry instanceof GeometryCollection || geometry instanceof Polygon) {
                    return;
                }
                Coordinate[] component = geometry.getCoordinates();
                for (int j = 0; j < component.length; ++j) {
                    ++index.value;
                    if (skipClosingVertex && component.length > 1 && j == component.length - 1 && component[j].equals((Object)component[0]) || pointLocator.locate(component[j], fence) == 2) continue;
                    coordinates.add(component[j]);
                    indices.add(new Integer(index.value));
                }
            }
        });
        return new VerticesInFence(){

            @Override
            public List getCoordinates() {
                return coordinates;
            }

            @Override
            public int getIndex(int i) {
                return (Integer)indices.get(i);
            }
        };
    }

    private String description(Layer layer, PlugInContext context) {
        boolean foundVertices = false;
        String description = "<Table width=100%><tr><td colspan=2 valign=top><i>Layer: </i><font color='#3300cc'><b>" + layer.getName() + "</b></font></td></tr>";
        String bgcolor = "darkgrey";
        for (Feature feature : layer.getFeatureCollectionWrapper().query(context.getLayerViewPanel().getFence().getEnvelopeInternal())) {
            VerticesInFence verticesInFence = VerticesInFencePlugIn.verticesInFence(feature.getGeometry(), context.getLayerViewPanel().getFence(), true);
            if (verticesInFence.getCoordinates().isEmpty()) continue;
            bgcolor = bgcolor.equals("#faebd7") ? "darkgrey" : "#faebd7";
            foundVertices = true;
            description = description + "<tr bgcolor=" + bgcolor + "><td width=10% valign=top><font size='-1'><i>Feature ID: </i></font><font size='-1' color='#3300cc'><b>" + feature.getID() + "</b></font><td>";
            description = description + this.description(verticesInFence, feature.getGeometry());
            description = description + "</td></tr>";
        }
        description = description + "</table>";
        return foundVertices ? description : "";
    }

    private String description(VerticesInFence verticesInFence, Geometry geometry) {
        StringBuffer description = new StringBuffer();
        description.append("<pre>");
        for (int i = 0; i < verticesInFence.getCoordinates().size(); ++i) {
            description.append(GUIUtil.escapeHTML("[" + Fmt.fmt(this.helper.annotation(geometry, (Coordinate)verticesInFence.getCoordinates().get(i)), 10) + "] " + this.wktWriter.write((Geometry)this.factory.createPoint((Coordinate)verticesInFence.getCoordinates().get(i))) + "\n", false, false));
        }
        description.append("</pre>");
        return description.toString();
    }

    private static class IntWrapper {
        public int value;

        public IntWrapper(int value) {
            this.value = value;
        }
    }

    public static interface VerticesInFence {
        public List getCoordinates();

        public int getIndex(int var1);
    }
}

