/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.analysis;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureDatasetFactory;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class BufferPlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    private static final String LAYER = "Layer";
    private static final String DISTANCE = "Buffer Distance";
    private MultiInputDialog dialog;
    private Layer layer;
    private double bufferDistance = 1.0;
    private boolean exceptionThrown = false;

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(dialog, context);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        return true;
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        FeatureSchema featureSchema = new FeatureSchema();
        featureSchema.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        FeatureCollection resultFC = new FeatureDataset(featureSchema);
        Collection resultColl = this.runBuffer(this.layer.getFeatureCollectionWrapper());
        resultFC = FeatureDatasetFactory.createFromGeometry(resultColl);
        context.addLayer("Working", "Buffer-" + this.layer.getName(), resultFC);
        if (this.exceptionThrown) {
            context.getWorkbenchFrame().warnUser("Errors found while executing buffer");
        }
    }

    private Collection runBuffer(FeatureCollection fcA) {
        this.exceptionThrown = false;
        ArrayList<Geometry> resultColl = new ArrayList<Geometry>();
        Iterator ia = fcA.iterator();
        while (ia.hasNext()) {
            Feature fa = (Feature)ia.next();
            Geometry ga = fa.getGeometry();
            Geometry result = this.runBuffer(ga);
            if (result == null) continue;
            resultColl.add(result);
        }
        return resultColl;
    }

    private Geometry runBuffer(Geometry a) {
        Geometry result = null;
        try {
            result = a.buffer(this.bufferDistance);
            return result;
        }
        catch (RuntimeException ex) {
            this.exceptionThrown = true;
            return null;
        }
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.setSideBarDescription("Buffers all geometries in the input layer");
        dialog.addLayerComboBox(LAYER, this.layer, context.getLayerManager());
        dialog.addDoubleField(DISTANCE, this.bufferDistance, 10, null);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.layer = dialog.getLayer(LAYER);
        this.bufferDistance = dialog.getDouble(DISTANCE);
    }
}

