/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.analysis;

import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.tools.AttributeMapping;
import com.vividsolutions.jump.tools.OverlayEngine;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import javax.swing.JComboBox;

public class OverlayPlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    private static final String POLYGON_OUTPUT = "Limit output to Polygons only";
    private static final String FIRST_LAYER = "First layer";
    private static final String SECOND_LAYER = "Second layer";
    private static final String TRANSFER_ATTRIBUTES_FROM_FIRST_LAYER = "Transfer attributes from first layer";
    private static final String TRANSFER_ATTRIBUTES_FROM_SECOND_LAYER = "Transfer attributes from second layer";
    private MultiInputDialog dialog;
    private OverlayEngine overlayEngine;

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.overlayEngine = this.prompt(context);
        return this.overlayEngine != null;
    }

    private OverlayEngine prompt(PlugInContext context) {
        this.initDialog(context);
        this.dialog.setVisible(true);
        if (!this.dialog.wasOKPressed()) {
            return null;
        }
        OverlayEngine e = new OverlayEngine();
        e.setAllowingPolygonsOnly(this.dialog.getBoolean(POLYGON_OUTPUT));
        e.setSplittingGeometryCollections(this.dialog.getBoolean(POLYGON_OUTPUT));
        return e;
    }

    private void initDialog(PlugInContext context) {
        this.dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.dialog.setSideBarImage(IconLoader.icon("Overlay.gif"));
        this.dialog.setSideBarDescription("Creates a new layer containing intersections of all pairs of input features.");
        String fieldName = FIRST_LAYER;
        JComboBox addLayerComboBox = this.dialog.addLayerComboBox(fieldName, context.getCandidateLayer(0), null, context.getLayerManager());
        String fieldName1 = SECOND_LAYER;
        JComboBox addLayerComboBox1 = this.dialog.addLayerComboBox(fieldName1, context.getCandidateLayer(1), null, context.getLayerManager());
        this.dialog.addCheckBox(POLYGON_OUTPUT, true, "Splits MultiPolygons and GeometryCollections, and filters out non-Polygons");
        this.dialog.addCheckBox(TRANSFER_ATTRIBUTES_FROM_FIRST_LAYER, true);
        this.dialog.addCheckBox(TRANSFER_ATTRIBUTES_FROM_SECOND_LAYER, true);
        GUIUtil.centreOnWindow(this.dialog);
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        FeatureCollectionWrapper a = this.dialog.getLayer(FIRST_LAYER).getFeatureCollectionWrapper();
        FeatureCollectionWrapper b = this.dialog.getLayer(SECOND_LAYER).getFeatureCollectionWrapper();
        FeatureCollection overlay = this.overlayEngine.overlay(a, b, this.mapping(a, b), monitor);
        context.addLayer("Working", "Overlay", overlay);
    }

    private AttributeMapping mapping(FeatureCollection a, FeatureCollection b) {
        return new AttributeMapping(this.dialog.getBoolean(TRANSFER_ATTRIBUTES_FROM_FIRST_LAYER) ? a.getFeatureSchema() : new FeatureSchema(), this.dialog.getBoolean(TRANSFER_ATTRIBUTES_FROM_SECOND_LAYER) ? b.getFeatureSchema() : new FeatureSchema());
    }
}

