/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.clipboard;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.ExportImagePlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.clipboard.AbstractTransferable;
import com.vividsolutions.jump.workbench.ui.plugin.clipboard.DummyClipboardOwner;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JComponent;

public class CopyImagePlugIn
extends ExportImagePlugIn {
    @Override
    public boolean execute(PlugInContext context) throws Exception {
        Transferable transferable = this.createTransferable(context);
        if (transferable == null) {
            context.getWorkbenchFrame().warnUser("Could not copy the image for some reason");
            return false;
        }
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(transferable, new DummyClipboardOwner());
        return true;
    }

    private Transferable createTransferable(final PlugInContext context) {
        return new AbstractTransferable(new DataFlavor[]{DataFlavor.imageFlavor}){

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                Assert.isTrue((flavor == DataFlavor.imageFlavor ? 1 : 0) != 0);
                return CopyImagePlugIn.this.image(context.getLayerViewPanel());
            }
        };
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return !CopyImagePlugIn.java14OrNewer() ? "This feature requires Java 1.4 or newer" : null;
            }
        });
    }
}

