/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.wms;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.InputChangedFirer;
import com.vividsolutions.jump.workbench.ui.InputChangedListener;
import com.vividsolutions.jump.workbench.ui.addremove.AddRemoveListModel;
import com.vividsolutions.jump.workbench.ui.addremove.AddRemovePanel;
import com.vividsolutions.jump.workbench.ui.addremove.DefaultAddRemoveList;
import com.vividsolutions.jump.workbench.ui.addremove.TreeAddRemoveList;
import com.vividsolutions.jump.workbench.ui.addremove.TreeAddRemoveListModel;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.wms.MapLayerTreeModel;
import com.vividsolutions.wms.MapLayer;
import com.vividsolutions.wms.WMService;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.tree.DefaultTreeCellRenderer;

public class MapLayerPanel
extends JPanel {
    public static final ImageIcon ICON = GUIUtil.resize(IconLoader.icon("country.gif"), 13);
    private InputChangedFirer inputChangedFirer = new InputChangedFirer();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private AddRemovePanel addRemovePanel = new AddRemovePanel(true);
    private JCheckBox checkBox = new JCheckBox("Sort", true);

    public MapLayerPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initAddRemovePanel();
    }

    public List getChosenMapLayers() {
        ArrayList<MapLayer> mapLayers = new ArrayList<MapLayer>();
        for (MapLayerTreeModel.LayerNode node : this.addRemovePanel.getRightItems()) {
            Assert.isTrue((node.getLayer().getName() != null ? 1 : 0) != 0);
            mapLayers.add(node.getLayer());
        }
        return mapLayers;
    }

    private void setRendererText(JLabel renderer, MapLayer layer) {
        renderer.setText(layer.getTitle() + " [" + StringUtil.toCommaDelimitedString(layer.getFullSRSList()) + "]");
    }

    void jbInit() throws Exception {
        this.addRemovePanel.setRightText("Chosen Layers");
        this.setLayout(this.gridBagLayout1);
        this.add((Component)this.addRemovePanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void add(InputChangedListener listener) {
        this.inputChangedFirer.add(listener);
    }

    public void remove(InputChangedListener listener) {
        this.inputChangedFirer.remove(listener);
    }

    private void addIfOnList(MapLayer layer, AddRemoveListModel model, Collection names) {
        if (names.contains(layer.getName())) {
            model.add(new MapLayerTreeModel.LayerNode(layer, null));
        }
        for (MapLayer child : layer.getSubLayerList()) {
            this.addIfOnList(child, model, names);
        }
    }

    public List commonSRSList() {
        List mapLayers = this.getChosenMapLayers();
        if (mapLayers.isEmpty()) {
            return new ArrayList();
        }
        ArrayList commonSRSList = new ArrayList(((MapLayer)mapLayers.get(0)).getFullSRSList());
        for (MapLayer layer : mapLayers) {
            commonSRSList.retainAll(layer.getFullSRSList());
        }
        return commonSRSList;
    }

    private void initAddRemovePanel() {
        TreeAddRemoveList leftList = new TreeAddRemoveList(){

            @Override
            public List getSelectedItems() {
                ArrayList selectedItems = new ArrayList(super.getSelectedItems());
                Iterator i = selectedItems.iterator();
                while (i.hasNext()) {
                    MapLayerTreeModel.LayerNode node = (MapLayerTreeModel.LayerNode)i.next();
                    if (!node.isContainer()) continue;
                    i.remove();
                }
                return selectedItems;
            }
        };
        this.addRemovePanel.setLeftList(leftList);
        leftList.getTree().setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                JLabel component = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                if (!(value instanceof MapLayerTreeModel.LayerNode)) {
                    return component;
                }
                MapLayer layer = ((MapLayerTreeModel.LayerNode)value).getLayer();
                MapLayerPanel.this.setRendererText(component, layer);
                if (layer.getName() == null) {
                    if (expanded) {
                        component.setIcon(UIManager.getIcon("Tree.openIcon"));
                    } else {
                        component.setIcon(UIManager.getIcon("Tree.closedIcon"));
                    }
                } else {
                    component.setIcon(ICON);
                }
                return component;
            }
        });
        DefaultAddRemoveList rightList = new DefaultAddRemoveList(new DefaultListModel(){

            public void addElement(Object obj) {
                if (this.contains(obj)) {
                    return;
                }
                super.addElement(obj);
            }
        });
        this.addRemovePanel.setRightList(rightList);
        rightList.getList().setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel component = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                MapLayer layer = ((MapLayerTreeModel.LayerNode)value).getLayer();
                MapLayerPanel.this.setRendererText(component, layer);
                component.setIcon(ICON);
                return component;
            }
        });
        leftList.add(new InputChangedListener(){

            @Override
            public void inputChanged() {
                MapLayerPanel.this.inputChangedFirer.fire();
            }
        });
        rightList.add(new InputChangedListener(){

            @Override
            public void inputChanged() {
                MapLayerPanel.this.inputChangedFirer.fire();
            }
        });
        rightList.getList().getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                MapLayerPanel.this.inputChangedFirer.fire();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                MapLayerPanel.this.inputChangedFirer.fire();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                MapLayerPanel.this.inputChangedFirer.fire();
            }
        });
        JPanel leftLabelPanel = new JPanel();
        leftLabelPanel.setLayout(new GridBagLayout());
        leftLabelPanel.add((Component)new JLabel("Available Layers"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        leftLabelPanel.add((Component)new JPanel(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapLayerPanel.this.setSorted(MapLayerPanel.this.checkBox.isSelected());
            }
        });
        leftLabelPanel.add((Component)this.checkBox, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.addRemovePanel.setLeftLabel(leftLabelPanel);
    }

    private void setSorted(boolean isSorted) {
        TreeAddRemoveList tarl = (TreeAddRemoveList)this.addRemovePanel.getLeftList();
        TreeAddRemoveListModel tarlm = (TreeAddRemoveListModel)tarl.getModel();
        MapLayerTreeModel mltm = (MapLayerTreeModel)tarlm.getTreeModel();
        mltm.setSorted(isSorted);
    }

    public void init(WMService service, Collection initialChosenMapLayers) {
        final MapLayerTreeModel treeModel = new MapLayerTreeModel(service.getCapabilities().getTopLayer());
        treeModel.setSorted(this.checkBox.isSelected());
        TreeAddRemoveListModel treeAddRemoveListModel = new TreeAddRemoveListModel(treeModel){

            @Override
            public List getItems() {
                ArrayList items = new ArrayList(MapLayerPanel.this.items((MapLayerTreeModel.LayerNode)treeModel.getRoot()));
                Iterator i = items.iterator();
                while (i.hasNext()) {
                    MapLayerTreeModel.LayerNode node = (MapLayerTreeModel.LayerNode)i.next();
                    if (!node.isContainer()) continue;
                    i.remove();
                }
                return items;
            }
        };
        ((TreeAddRemoveList)this.addRemovePanel.getLeftList()).setModel(treeAddRemoveListModel);
        if (initialChosenMapLayers != null) {
            this.addIfOnList(service.getCapabilities().getTopLayer(), this.addRemovePanel.getRightList().getModel(), initialChosenMapLayers);
        }
        this.addRemovePanel.updateEnabled();
    }

    private List items(MapLayerTreeModel.LayerNode node) {
        ArrayList<MapLayerTreeModel.LayerNode> items = new ArrayList<MapLayerTreeModel.LayerNode>();
        items.add(node);
        Enumeration e = node.children();
        while (e.hasMoreElements()) {
            MapLayerTreeModel.LayerNode child = (MapLayerTreeModel.LayerNode)e.nextElement();
            items.addAll(this.items(child));
        }
        items.removeAll(this.addRemovePanel.getRightItems());
        return items;
    }
}

