/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.renderer.ImageCachingRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.ThreadSafeImage;
import com.vividsolutions.jump.workbench.ui.renderer.style.Style;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ImageCachingFeatureCollectionRenderer
extends ImageCachingRenderer {
    private Collection styles = new ArrayList();
    private Map layerToFeaturesMap = new HashMap();

    public ImageCachingFeatureCollectionRenderer(Object contentID, LayerViewPanel panel) {
        super(contentID, panel);
    }

    protected void setLayerToFeaturesMap(Map layerToFeaturesMap) {
        this.layerToFeaturesMap = layerToFeaturesMap;
    }

    protected void setStyles(Collection styles) {
        this.styles = styles;
    }

    protected void renderHook(ThreadSafeImage image, Collection features, Layer layer, final Style style) throws Exception {
        if (!layer.isVisible()) {
            return;
        }
        if (!style.isEnabled()) {
            return;
        }
        style.initialize(layer);
        for (final Feature feature : new ArrayList(features)) {
            if (this.cancelled) break;
            if (feature.getGeometry().isEmpty()) continue;
            image.draw(new ThreadSafeImage.Drawer(){

                @Override
                public void draw(Graphics2D g) throws Exception {
                    style.paint(feature, g, ImageCachingFeatureCollectionRenderer.this.panel.getViewport());
                }
            });
        }
    }

    @Override
    protected void renderHook(ThreadSafeImage image) throws Exception {
        for (Style style : this.styles) {
            for (Layer layer : this.layerToFeaturesMap.keySet()) {
                Collection features = (Collection)this.layerToFeaturesMap.get(layer);
                this.renderHook(image, features, layer, style);
            }
        }
    }
}

