/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.renderer.FeatureCollectionRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.ImageCachingFeatureCollectionRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.ThreadSafeImage;
import com.vividsolutions.jump.workbench.ui.renderer.style.Style;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class LayerRenderer
extends FeatureCollectionRenderer {
    private Layer layer;
    private LayerViewPanel panel;

    public LayerRenderer(final Layer layer, LayerViewPanel panel) {
        super(layer, panel, new ImageCachingFeatureCollectionRenderer(layer, panel){

            @Override
            protected ThreadSafeImage getImage() {
                if (!layer.isVisible()) {
                    return null;
                }
                return super.getImage();
            }

            @Override
            public Runnable createRunnable() {
                if (!layer.isVisible()) {
                    return null;
                }
                return super.createRunnable();
            }
        });
        this.layer = layer;
        this.panel = panel;
    }

    @Override
    protected Collection styles() {
        ArrayList<Style> styles = new ArrayList<Style>(this.layer.getStyles());
        styles.remove(this.layer.getVertexStyle());
        styles.remove(this.layer.getLabelStyle());
        styles.add(this.layer.getVertexStyle());
        styles.add(this.layer.getLabelStyle());
        return styles;
    }

    @Override
    protected Map layerToFeaturesMap() {
        Envelope viewportEnvelope = this.panel.getViewport().getEnvelopeInModelCoordinates();
        return Collections.singletonMap(this.layer, this.layer.getFeatureCollectionWrapper().query(viewportEnvelope));
    }
}

