/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.snap;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.snap.SnapManager;
import com.vividsolutions.jump.workbench.ui.snap.SnapPolicy;

public class SnapToGridPolicy
implements SnapPolicy {
    public static final String ENABLED_KEY = SnapToGridPolicy.class.getName() + " - ENABLED";
    public static final String GRID_SIZE_KEY = SnapToGridPolicy.class.getName() + " - GRID_SIZE";
    private Blackboard blackboard;

    public SnapToGridPolicy(Blackboard blackboard) {
        this.blackboard = blackboard;
    }

    @Override
    public Coordinate snap(LayerViewPanel panel, Coordinate originalCoordinate) {
        if (!this.blackboard.get(ENABLED_KEY, false)) {
            return null;
        }
        double gridSize = this.blackboard.get(GRID_SIZE_KEY, 20.0);
        Coordinate gridCoordinate = new Coordinate((double)Math.round(originalCoordinate.x / gridSize) * gridSize, (double)Math.round(originalCoordinate.y / gridSize) * gridSize);
        return gridCoordinate.distance(originalCoordinate) <= (double)SnapManager.getToleranceInPixels(this.blackboard) / panel.getViewport().getScale() ? gridCoordinate : originalCoordinate;
    }
}

