/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.style;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.ErrorHandler;
import com.vividsolutions.jump.workbench.ui.FontChooser;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.ValidatingTextField;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.renderer.style.LabelStyle;
import com.vividsolutions.jump.workbench.ui.style.StylePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class LabelStylePanel
extends JPanel
implements StylePanel {
    private static final String NONE = "(none)";
    private BorderLayout borderLayout1 = new BorderLayout();
    private GridBagLayout gridBagLayout6 = new GridBagLayout();
    private JLabel attributeLabel = new JLabel();
    private JComboBox attributeComboBox = new JComboBox();
    private JComboBox angleAttributeComboBox = new JComboBox();
    private JPanel previewPanel = new JPanel(){

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            LabelStyle labelStyle = LabelStylePanel.this.createLabelStyle(LabelStylePanel.this.layer.getLabelStyle());
            if (!labelStyle.isEnabled()) {
                return;
            }
            labelStyle.initialize(LabelStylePanel.this.layer);
            labelStyle.paint((Graphics2D)g, LabelStylePanel.this.sampleText(), LabelStylePanel.this.layerViewPanel.getViewport().getScale(), new Point2D.Double((double)this.getWidth() / 2.0, (double)this.getHeight() / 2.0), LabelStylePanel.this.layer.getFeatureCollectionWrapper().isEmpty() ? 0.0 : LabelStyle.angle((Feature)LabelStylePanel.this.layer.getFeatureCollectionWrapper().iterator().next(), LabelStylePanel.this.getAngleAttribute(), 0.0), LabelStylePanel.this.layer.getFeatureCollectionWrapper().isEmpty() ? LabelStylePanel.this.getLabelHeight() : LabelStyle.height((Feature)LabelStylePanel.this.layer.getFeatureCollectionWrapper().iterator().next(), LabelStylePanel.this.getHeightAttribute(), LabelStylePanel.this.getLabelHeight()), false);
        }
    };
    private JCheckBox scaleCheckBox = new JCheckBox();
    private Layer layer;
    private JCheckBox labellingCheckBox = new JCheckBox();
    private Border border1;
    private LayerViewPanel layerViewPanel;
    private JDialog parent;
    private Color color;
    private Font labelFont;
    private ValidatingTextField heightTextField = new ValidatingTextField("999", 7, new ValidatingTextField.Validator(){

        @Override
        public boolean isValid(String text) {
            if (text.length() == 0) {
                return true;
            }
            try {
                Double.parseDouble(text);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    });
    private JLabel heightLabel = new JLabel();
    private JLabel previewLabel = new JLabel();
    private JPanel fillerPanel = new JPanel();
    private JPanel buttonPanel = new JPanel();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private JButton colorButton = new JButton();
    private JButton fontButton = new JButton();
    private JPanel jPanel3 = new JPanel();
    private JLabel verticalAlignmentLabel = new JLabel();
    private JComboBox verticalAlignmentComboBox = new JComboBox();
    private JLabel angleLabel = new JLabel();
    private JCheckBox hideOverlappingLabelsCheckBox = new JCheckBox();
    private JLabel heightAttributeLabel = new JLabel();
    private JComboBox heightAttributeComboBox = new JComboBox();

    @Override
    public String getTitle() {
        return "Labels";
    }

    @Override
    public String validateInput() {
        return null;
    }

    public LabelStylePanel(Layer layer, LayerViewPanel layerViewPanel, JDialog parent, ErrorHandler errorHandler) {
        try {
            this.parent = parent;
            this.layerViewPanel = layerViewPanel;
            this.verticalAlignmentComboBox.addItem("ABOVE_LINE");
            this.verticalAlignmentComboBox.addItem("ON_LINE");
            this.verticalAlignmentComboBox.addItem("BELOW_LINE");
            this.setLayer(layer);
            this.jbInit();
            this.heightTextField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.documentChanged();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.documentChanged();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.documentChanged();
                }

                private void documentChanged() {
                    LabelStylePanel.this.updateControls();
                }
            });
            this.colorButton.setToolTipText("Browse");
            this.fontButton.setToolTipText("Browse");
            this.updateControls();
            this.verticalAlignmentComboBox.setRenderer(new ListCellRenderer(){
                private Icon aboveIcon = IconLoader.icon("BigLabelAbove.gif");
                private Icon onIcon = IconLoader.icon("BigLabelOn.gif");
                private Icon belowIcon = IconLoader.icon("BigLabelBelow.gif");
                private DefaultListCellRenderer renderer = new DefaultListCellRenderer();

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    JLabel label = (JLabel)this.renderer.getListCellRendererComponent((JList<?>)list, "", index, isSelected, cellHasFocus);
                    label.setIcon(value.equals("ABOVE_LINE") ? this.aboveIcon : (value.equals("ON_LINE") ? this.onIcon : this.belowIcon));
                    return label;
                }
            });
        }
        catch (Throwable t) {
            errorHandler.handleThrowable(t);
        }
    }

    private String sampleText() {
        Object attribute;
        String sampleText = "Abc123";
        if (this.layer.getFeatureCollectionWrapper().isEmpty()) {
            return sampleText;
        }
        Feature firstFeature = (Feature)this.layer.getFeatureCollectionWrapper().iterator().next();
        Object object = attribute = this.getLabelAttribute().equals("$FID") ? firstFeature.getID() + "" : firstFeature.getAttribute(this.getLabelAttribute());
        if (attribute == null) {
            return sampleText;
        }
        if (attribute.toString().trim().length() == 0) {
            return sampleText;
        }
        return attribute.toString().trim();
    }

    private void setLayer(Layer layer) {
        this.layer = layer;
        this.setLabelling(layer.getLabelStyle().isEnabled());
        this.setAttributes(layer.getFeatureCollectionWrapper().getFeatureSchema());
        this.setAttribute(layer.getLabelStyle().getAttribute());
        this.setAngleAttribute(layer.getLabelStyle().getAngleAttribute());
        this.setHeightAttribute(layer.getLabelStyle().getHeightAttribute());
        this.setColor(layer.getLabelStyle().getColor());
        this.setLabelFont(layer.getLabelStyle().getFont());
        this.setScaling(layer.getLabelStyle().isScaling());
        this.hideOverlappingLabelsCheckBox.setSelected(layer.getLabelStyle().isHidingOverlappingLabels());
        this.heightTextField.setText(layer.getLabelStyle().getHeight() + "");
        this.verticalAlignmentComboBox.setSelectedItem(layer.getLabelStyle().getVerticalAlignment());
    }

    private void setAttributes(FeatureSchema schema) {
        this.attributeComboBox.removeAllItems();
        this.angleAttributeComboBox.removeAllItems();
        this.heightAttributeComboBox.removeAllItems();
        this.attributeComboBox.addItem("$FID");
        this.angleAttributeComboBox.addItem(NONE);
        this.heightAttributeComboBox.addItem(NONE);
        for (int i = 0; i < schema.getAttributeCount(); ++i) {
            this.attributeComboBox.addItem(schema.getAttributeName(i));
            if (schema.getAttributeType(i) != AttributeType.DOUBLE && schema.getAttributeType(i) != AttributeType.INTEGER) continue;
            this.angleAttributeComboBox.addItem(schema.getAttributeName(i));
            this.heightAttributeComboBox.addItem(schema.getAttributeName(i));
        }
    }

    private void setLabelling(boolean labelling) {
        this.labellingCheckBox.setSelected(labelling);
    }

    private void setColor(Color color) {
        this.color = color;
    }

    private void setAttribute(String attribute) {
        Assert.isTrue((!attribute.equals("") ? 1 : 0) != 0);
        this.attributeComboBox.setSelectedItem(attribute);
    }

    private void setAngleAttribute(String angleAttribute) {
        if (angleAttribute.equals("")) {
            this.angleAttributeComboBox.setSelectedItem(NONE);
            return;
        }
        this.angleAttributeComboBox.setSelectedItem(angleAttribute);
    }

    private void setHeightAttribute(String heightAttribute) {
        if (heightAttribute.equals("")) {
            this.heightAttributeComboBox.setSelectedItem(NONE);
            return;
        }
        this.heightAttributeComboBox.setSelectedItem(heightAttribute);
    }

    private void setLabelFont(Font labelFont) {
        this.labelFont = labelFont;
    }

    private void setScaling(boolean scaling) {
        this.scaleCheckBox.setSelected(scaling);
    }

    void jbInit() throws Exception {
        this.border1 = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        this.setLayout(this.borderLayout1);
        this.setLayout(this.gridBagLayout6);
        this.attributeLabel.setText("Label attribute:");
        this.previewPanel.setBackground(Color.white);
        this.previewPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.previewPanel.setMaximumSize(new Dimension(200, 40));
        this.previewPanel.setMinimumSize(new Dimension(200, 40));
        this.previewPanel.setPreferredSize(new Dimension(200, 40));
        this.scaleCheckBox.setText("Scale labels with the zoom level");
        this.scaleCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LabelStylePanel.this.scaleCheckBox_actionPerformed(e);
            }
        });
        this.setBorder(this.border1);
        this.labellingCheckBox.setText("Enable labelling");
        this.labellingCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LabelStylePanel.this.enableLabellingCheckBox_actionPerformed(e);
            }
        });
        this.heightLabel.setText("Height:");
        this.attributeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LabelStylePanel.this.attributeComboBox_actionPerformed(e);
            }
        });
        this.angleAttributeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LabelStylePanel.this.angleAttributeComboBox_actionPerformed(e);
            }
        });
        this.previewLabel.setText("Preview at current zoom level:");
        this.buttonPanel.setLayout(this.gridBagLayout2);
        this.colorButton.setText("Change Colour...");
        this.colorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LabelStylePanel.this.colorButton_actionPerformed(e);
            }
        });
        this.fontButton.setText("Change Font...");
        this.fontButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LabelStylePanel.this.fontButton_actionPerformed(e);
            }
        });
        this.verticalAlignmentLabel.setText("Vertical alignment (for lines):");
        this.verticalAlignmentComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LabelStylePanel.this.verticalAlignmentComboBox_actionPerformed(e);
            }
        });
        this.angleLabel.setText("Angle attribute (degrees):");
        this.hideOverlappingLabelsCheckBox.setText("Hide overlapping labels");
        this.hideOverlappingLabelsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LabelStylePanel.this.hideOverlappingLabelsCheckBox_actionPerformed(e);
            }
        });
        this.heightAttributeLabel.setText("Height attribute:");
        this.heightAttributeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LabelStylePanel.this.heightAttributeComboBox_actionPerformed(e);
            }
        });
        this.add((Component)this.attributeLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.attributeComboBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 4, 2, 0), 0, 0));
        this.add((Component)this.angleAttributeComboBox, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 2, 0), 0, 0));
        this.add((Component)this.previewPanel, new GridBagConstraints(0, 13, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 4, 4), 0, 0));
        this.add((Component)this.scaleCheckBox, new GridBagConstraints(0, 9, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.labellingCheckBox, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.heightTextField, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        this.add((Component)this.heightLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.previewLabel, new GridBagConstraints(0, 12, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.fillerPanel, new GridBagConstraints(98, 104, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.buttonPanel, new GridBagConstraints(0, 11, 3, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonPanel.add((Component)this.colorButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.buttonPanel.add((Component)this.fontButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.buttonPanel.add((Component)this.jPanel3, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.verticalAlignmentLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.verticalAlignmentComboBox, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 4, 2, 0), 0, 0));
        this.add((Component)this.angleLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.hideOverlappingLabelsCheckBox, new GridBagConstraints(0, 10, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.heightAttributeLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.heightAttributeComboBox, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 4, 2, 0), 0, 0));
    }

    @Override
    public void updateStyles() {
        boolean firingEvents = this.layer.getLayerManager().isFiringEvents();
        this.layer.getLayerManager().setFiringEvents(false);
        try {
            LabelStyle newLabelStyle = this.createLabelStyle(this.layer.getLabelStyle());
            this.layer.removeStyle(this.layer.getLabelStyle());
            this.layer.addStyle(newLabelStyle);
        }
        finally {
            this.layer.getLayerManager().setFiringEvents(firingEvents);
        }
        this.layer.fireAppearanceChanged();
    }

    private String getAngleAttribute() {
        if (NONE == this.angleAttributeComboBox.getSelectedItem()) {
            return "";
        }
        return (String)this.angleAttributeComboBox.getSelectedItem();
    }

    private String getHeightAttribute() {
        if (NONE == this.heightAttributeComboBox.getSelectedItem()) {
            return "";
        }
        return (String)this.heightAttributeComboBox.getSelectedItem();
    }

    private String getLabelAttribute() {
        return (String)this.attributeComboBox.getSelectedItem();
    }

    public LabelStyle createLabelStyle(LabelStyle defaultValues) {
        LabelStyle labelStyle = (LabelStyle)defaultValues.clone();
        labelStyle.setEnabled(this.labellingCheckBox.isSelected());
        Assert.isTrue((this.attributeComboBox.getSelectedIndex() != -1 ? 1 : 0) != 0);
        labelStyle.setAttribute(this.getLabelAttribute());
        labelStyle.setAngleAttribute(this.getAngleAttribute());
        labelStyle.setHeightAttribute(this.getHeightAttribute());
        labelStyle.setColor(this.color);
        labelStyle.setFont(this.labelFont);
        labelStyle.setScaling(this.scaleCheckBox.isSelected());
        labelStyle.setHidingOverlappingLabels(this.hideOverlappingLabelsCheckBox.isSelected());
        labelStyle.setHeight(this.getLabelHeight());
        labelStyle.setVerticalAlignment((String)this.verticalAlignmentComboBox.getSelectedItem());
        return labelStyle;
    }

    private double getLabelHeight() {
        return this.heightTextField.getText().length() == 0 ? 12.0 : Double.parseDouble(this.heightTextField.getText());
    }

    public void updateControls() {
        this.previewPanel.repaint();
        this.attributeLabel.setEnabled(this.labellingCheckBox.isSelected());
        this.angleLabel.setEnabled(this.labellingCheckBox.isSelected());
        this.heightAttributeLabel.setEnabled(this.labellingCheckBox.isSelected());
        this.attributeComboBox.setEnabled(this.labellingCheckBox.isSelected());
        this.angleAttributeComboBox.setEnabled(this.labellingCheckBox.isSelected());
        this.heightAttributeComboBox.setEnabled(this.labellingCheckBox.isSelected());
        this.colorButton.setEnabled(this.labellingCheckBox.isSelected());
        this.fontButton.setEnabled(this.labellingCheckBox.isSelected());
        this.heightLabel.setEnabled(this.labellingCheckBox.isSelected() && this.getHeightAttribute().equals(""));
        this.heightTextField.setEnabled(this.labellingCheckBox.isSelected() && this.getHeightAttribute().equals(""));
        this.scaleCheckBox.setEnabled(this.labellingCheckBox.isSelected());
        this.hideOverlappingLabelsCheckBox.setEnabled(this.labellingCheckBox.isSelected());
        this.previewLabel.setEnabled(this.labellingCheckBox.isSelected());
        this.previewPanel.setEnabled(this.labellingCheckBox.isSelected());
        this.verticalAlignmentLabel.setEnabled(this.labellingCheckBox.isSelected());
        this.verticalAlignmentComboBox.setEnabled(this.labellingCheckBox.isSelected());
    }

    void colorButton_actionPerformed(ActionEvent e) {
        Color newColor = JColorChooser.showDialog(this, "Choose Colour", this.color);
        if (newColor == null) {
            return;
        }
        this.setColor(newColor);
        this.updateControls();
    }

    void fontButton_actionPerformed(ActionEvent e) {
        Font newFont = FontChooser.showDialog(this.parent, "Choose Font", this.labelFont);
        if (newFont == null) {
            return;
        }
        this.setLabelFont(newFont);
        this.updateControls();
    }

    void enableLabellingCheckBox_actionPerformed(ActionEvent e) {
        this.updateControls();
    }

    void attributeComboBox_actionPerformed(ActionEvent e) {
        this.updateControls();
    }

    void angleAttributeComboBox_actionPerformed(ActionEvent e) {
        this.updateControls();
    }

    void scaleCheckBox_actionPerformed(ActionEvent e) {
        this.updateControls();
    }

    void verticalAlignmentComboBox_actionPerformed(ActionEvent e) {
        this.updateControls();
    }

    void hideOverlappingLabelsCheckBox_actionPerformed(ActionEvent e) {
        this.updateControls();
    }

    void heightAttributeComboBox_actionPerformed(ActionEvent e) {
        this.updateControls();
    }
}

