/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.toolbox;

import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.util.Block;
import com.vividsolutions.jump.util.LangUtil;
import com.vividsolutions.jump.util.OrderedMap;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerComboBox;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.WorkbenchToolBar;
import com.vividsolutions.jump.workbench.ui.toolbox.ToolboxDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.text.JTextComponent;

public class ToolboxStateManager {
    private static int keyIndex = 0;
    private OrderedMap componentClassToStrategyMap = new OrderedMap(){
        {
            this.put(JTextComponent.class, new Strategy(){

                @Override
                protected void addActionListener(ActionListener actionListener, Component component) {
                    ((JTextComponent)component).getDocument().addDocumentListener(GUIUtil.toDocumentListener(actionListener));
                }

                @Override
                protected Object getToolboxValue(Component component) {
                    return ((JTextComponent)component).getText();
                }

                @Override
                protected void setToolboxValue(Object value, Component component) {
                    ((JTextComponent)component).setText((String)value);
                }
            });
            this.put(JToggleButton.class, new Strategy(){

                @Override
                protected void addActionListener(ActionListener actionListener, Component component) {
                    ((JToggleButton)component).addActionListener(actionListener);
                }

                @Override
                protected Object getToolboxValue(Component component) {
                    return new Boolean(((JToggleButton)component).isSelected());
                }

                @Override
                protected void setToolboxValue(Object value, Component component) {
                    ((JToggleButton)component).setSelected((Boolean)value);
                }
            });
            this.put(LayerComboBox.class, new Strategy(){

                @Override
                protected void addActionListener(ActionListener actionListener, Component component) {
                    ((LayerComboBox)component).getModel().addListDataListener(GUIUtil.toListDataListener(actionListener));
                }

                @Override
                protected Object getDefaultValue(Object initialToolboxValue, Component component) {
                    LayerManager layerManager = (LayerManager)LangUtil.ifNull(((WorkbenchFrame)SwingUtilities.getAncestorOfClass(WorkbenchFrame.class, component)).getContext().getLayerManager(), new LayerManager());
                    return new Object[]{layerManager.size() > 0 ? layerManager.iterator().next() : null, layerManager};
                }

                @Override
                protected Object getToolboxValue(Component component) {
                    return new Object[]{((LayerComboBox)component).getSelectedItem(), ((LayerComboBox)component).getLayerManager()};
                }

                @Override
                protected void setToolboxValue(Object value, Component component) {
                    ((LayerComboBox)component).setLayerManager((LayerManager)((Object[])value)[1]);
                    ((LayerComboBox)component).setSelectedItem(((Object[])value)[0]);
                }
            });
            this.put(JComboBox.class, new Strategy(){

                @Override
                protected void addActionListener(ActionListener actionListener, Component component) {
                    ((JComboBox)component).addActionListener(actionListener);
                    ((JComboBox)component).getModel().addListDataListener(GUIUtil.toListDataListener(actionListener));
                }

                @Override
                protected Object getToolboxValue(Component component) {
                    Vector items = new Vector();
                    for (int i = 0; i < ((JComboBox)component).getItemCount(); ++i) {
                        items.add(((JComboBox)component).getItemAt(i));
                    }
                    return new Object[]{((JComboBox)component).getSelectedItem(), items};
                }

                @Override
                protected void setToolboxValue(Object value, Component component) {
                    ((JComboBox)component).setModel(new DefaultComboBoxModel((Vector)((Object[])value)[1]));
                    ((JComboBox)component).setSelectedItem(((Object[])value)[0]);
                }
            });
        }
    };
    private WorkbenchContext workbenchContext;
    private Blackboard dummyBlackboard = new Blackboard();

    public ToolboxStateManager(ToolboxDialog toolbox) {
        this(toolbox, new HashMap());
    }

    public ToolboxStateManager(ToolboxDialog toolbox, Map customComponentClassToStrategyMap) {
        this.workbenchContext = toolbox.getContext();
        this.componentClassToStrategyMap.putAll(customComponentClassToStrategyMap);
        this.monitor(toolbox);
    }

    private Blackboard getBlackboard() {
        return this.workbenchContext.getLayerManager() == null ? this.dummyBlackboard : this.workbenchContext.getLayerManager().getBlackboard();
    }

    private ToolboxStateManager monitor(Component component) {
        if (null != SwingUtilities.getAncestorOfClass(WorkbenchToolBar.class, component)) {
            return this;
        }
        for (Class componentClass : this.componentClassToStrategyMap.keyList()) {
            if (!componentClass.isInstance(component)) continue;
            ((Strategy)this.componentClassToStrategyMap.get(componentClass)).monitor(component, this);
            return this;
        }
        if (component instanceof Container) {
            for (int i = 0; i < ((Container)component).getComponentCount(); ++i) {
                this.monitor(((Container)component).getComponent(i));
            }
        }
        return this;
    }

    public static abstract class Strategy {
        private boolean updating = false;

        public void monitor(final Component component, final ToolboxStateManager manager) {
            final String key = ToolboxStateManager.class.getName() + " - " + ++keyIndex;
            final Object initialValue = this.getToolboxValue(component);
            final Block updateBlackboardBlock = new Block(){

                @Override
                public Object yield() {
                    updating = true;
                    try {
                        this.setToolboxValue(manager.getBlackboard().get(key, this.getDefaultValue(initialValue, component)), component);
                    }
                    finally {
                        updating = false;
                    }
                    return null;
                }
            };
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (updating) {
                        return;
                    }
                    manager.getBlackboard().put(key, this.getToolboxValue(component));
                }
            };
            updateBlackboardBlock.yield();
            actionListener.actionPerformed(null);
            this.addActionListener(actionListener, component);
            GUIUtil.addInternalFrameListener(manager.workbenchContext.getWorkbench().getFrame().getDesktopPane(), new InternalFrameAdapter(){

                @Override
                public void internalFrameActivated(InternalFrameEvent e) {
                    updateBlackboardBlock.yield();
                }

                @Override
                public void internalFrameDeactivated(InternalFrameEvent e) {
                    updateBlackboardBlock.yield();
                }
            });
        }

        protected Object getDefaultValue(Object initialToolboxValue, Component component) {
            return initialToolboxValue;
        }

        protected abstract void addActionListener(ActionListener var1, Component var2);

        protected abstract Object getToolboxValue(Component var1);

        protected abstract void setToolboxValue(Object var1, Component var2);
    }
}

