/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.warp;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.warp.AffineTransform;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.warp.WarpingVectorLayerFinder;
import java.util.Iterator;

public class AffineTransformPlugIn
extends AbstractPlugIn {
    @Override
    public void initialize(PlugInContext context) throws Exception {
        context.getFeatureInstaller().addMainMenuItem(this, new String[]{"Tools", "Warping"}, this.getName(), false, null, new MultiEnableCheck().add(context.getCheckFactory().createWindowWithLayerViewPanelMustBeActiveCheck()).add(context.getCheckFactory().createWindowWithLayerNamePanelMustBeActiveCheck()).add(context.getCheckFactory().createExactlyNLayersMustBeSelectedCheck(1)).add(context.getCheckFactory().createBetweenNAndMVectorsMustBeDrawnCheck(1, 3)));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        AffineTransform transform = this.affineTransform(context);
        FeatureCollection featureCollection = transform.transform(context.getSelectedLayer(0).getFeatureCollectionWrapper());
        context.getLayerManager().addLayer("Working", "Affined " + context.getSelectedLayer(0).getName(), featureCollection);
        AffineTransformPlugIn.checkValid(featureCollection, context);
        return true;
    }

    public static void checkValid(FeatureCollection featureCollection, PlugInContext context) {
        Iterator i = featureCollection.iterator();
        while (i.hasNext()) {
            Feature feature = (Feature)i.next();
            if (feature.getGeometry().isValid()) continue;
            context.getLayerViewPanel().getContext().warnUser("Some geometries are not valid");
            return;
        }
    }

    private Coordinate vectorCoordinate(int n, boolean tip, PlugInContext context, WarpingVectorLayerFinder vectorLayerManager) {
        LineString vector = (LineString)vectorLayerManager.getVectors().get(n);
        return tip ? vector.getCoordinateN(1) : vector.getCoordinateN(0);
    }

    private AffineTransform affineTransform(PlugInContext context) {
        WarpingVectorLayerFinder vlm = new WarpingVectorLayerFinder(context);
        switch (vlm.getVectors().size()) {
            case 1: {
                return new AffineTransform(this.vectorCoordinate(0, false, context, vlm), this.vectorCoordinate(0, true, context, vlm));
            }
            case 2: {
                return new AffineTransform(this.vectorCoordinate(0, false, context, vlm), this.vectorCoordinate(0, true, context, vlm), this.vectorCoordinate(1, false, context, vlm), this.vectorCoordinate(1, true, context, vlm));
            }
            case 3: {
                return new AffineTransform(this.vectorCoordinate(0, false, context, vlm), this.vectorCoordinate(0, true, context, vlm), this.vectorCoordinate(1, false, context, vlm), this.vectorCoordinate(1, true, context, vlm), this.vectorCoordinate(2, false, context, vlm), this.vectorCoordinate(2, true, context, vlm));
            }
        }
        Assert.shouldNeverReachHere();
        return null;
    }
}

