/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.zoom;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jump.workbench.ui.cursortool.DragTool;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import javax.swing.Icon;

public class PanTool
extends DragTool {
    private boolean dragging = false;
    private Image image;

    @Override
    public Cursor getCursor() {
        return PanTool.createCursor(IconLoader.icon("Hand.gif").getImage());
    }

    @Override
    public Icon getIcon() {
        return IconLoader.icon("BigHand.gif");
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        try {
            if (!this.dragging) {
                this.dragging = true;
                this.getPanel().getRenderingManager().setPaintingEnabled(false);
                this.cacheImage();
            }
            this.getPanel().erase((Graphics2D)this.getPanel().getGraphics());
            this.drawImage(e.getPoint());
            super.mouseDragged(e);
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.dragging) {
            return;
        }
        this.getPanel().getRenderingManager().setPaintingEnabled(true);
        this.dragging = false;
        super.mouseReleased(e);
    }

    @Override
    protected Shape getShape(Point2D source, Point2D destination) {
        return null;
    }

    @Override
    protected void gestureFinished() throws NoninvertibleTransformException {
        this.reportNothingToUndoYet();
        double xDisplacement = this.getModelDestination().x - this.getModelSource().x;
        double yDisplacement = this.getModelDestination().y - this.getModelSource().y;
        Envelope oldEnvelope = this.getPanel().getViewport().getEnvelopeInModelCoordinates();
        this.getPanel().getViewport().zoom(new Envelope(oldEnvelope.getMinX() - xDisplacement, oldEnvelope.getMaxX() - xDisplacement, oldEnvelope.getMinY() - yDisplacement, oldEnvelope.getMaxY() - yDisplacement));
    }

    private void cacheImage() {
        this.image = this.getPanel().createBlankPanelImage();
        this.getPanel().paint(this.image.getGraphics());
    }

    private void drawImage(Point p) throws NoninvertibleTransformException {
        double dx = p.getX() - this.getViewSource().getX();
        double dy = p.getY() - this.getViewSource().getY();
        this.getPanel().getGraphics().drawImage(this.image, (int)dx, (int)dy, this.getPanel());
    }
}

