/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.zoom;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class ZoomNextPlugIn
extends AbstractPlugIn {
    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        Viewport viewport = context.getLayerViewPanel().getViewport();
        Assert.isTrue((boolean)viewport.getZoomHistory().hasNext());
        viewport.getZoomHistory().setAdding(false);
        try {
            viewport.zoom(viewport.getZoomHistory().next());
        }
        finally {
            viewport.getZoomHistory().setAdding(true);
        }
        return true;
    }

    public MultiEnableCheck createEnableCheck(final WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return !workbenchContext.getLayerViewPanel().getViewport().getZoomHistory().hasNext() ? "Already at end" : null;
            }
        });
    }

    public ImageIcon getIcon() {
        return IconLoader.icon("Right.gif");
    }
}

