
/*
 * The Unified Mapping Platform (JUMP) is an extensible, interactive GUI 
 * for visualizing and manipulating spatial features with geometry and attributes.
 *
 * Copyright (C) 2003 Vivid Solutions
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * For more information, contact:
 *
 * Vivid Solutions
 * Suite #1A
 * 2328 Government Street
 * Victoria BC  V8T 5G5
 * Canada
 *
 * (250)385-6040
 * www.vividsolutions.com
 */

package org.locationtech.jts.jump.workbench.ui.cursortool;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.List;

import javax.swing.Icon;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.jump.workbench.ui.LayerViewPanel;
import org.locationtech.jts.jump.workbench.ui.images.IconLoader;


public class MeasureTool extends MultiClickTool {
    public MeasureTool() {
        allowSnapping();
    }

    public Icon getIcon() {
        return IconLoader.icon("Ruler.gif");
    }

    public Cursor getCursor() {
        return createCursor(IconLoader.icon("RulerCursor.gif").getImage());
    }

    public void mouseLocationChanged(MouseEvent e) {
        try {
            if (isShapeOnScreen()) {
                ArrayList currentCoordinates = new ArrayList(getCoordinates());
                currentCoordinates.add(getPanel().getViewport().toModelCoordinate(e.getPoint()));
                display(currentCoordinates, getPanel());
            }

            super.mouseLocationChanged(e);
        } catch (Throwable t) {
            getPanel().getContext().handleThrowable(t);
        }
    }

    protected void gestureFinished() throws NoninvertibleTransformException {
        reportNothingToUndoYet();

        //Status bar is cleared before #gestureFinished is called. So redisplay
        //the length. [Jon Aquino]
        display(getCoordinates(), getPanel());
    }

    private void display(List coordinates, LayerViewPanel panel)
        throws NoninvertibleTransformException {
        display(distance(coordinates), panel);
    }

    private void display(double distance, LayerViewPanel panel) {
        panel.getContext().setStatusMessage("Distance: " +
            panel.format(distance));
    }

    private double distance(List coordinates) {
        double distance = 0;

        for (int i = 1; i < coordinates.size(); i++) {
            distance += ((Coordinate) coordinates.get(i - 1)).distance((Coordinate) coordinates.get(
                    i));
        }

        return distance;
    }
}
