/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.coordsys;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.locationtech.jts.jump.coordsys.CoordinateSystem;
import org.locationtech.jts.jump.coordsys.impl.PredefinedCoordinateSystems;
import org.locationtech.jts.jump.util.Blackboard;

public class CoordinateSystemRegistry {
    private HashMap nameToCoordinateSystemMap = new HashMap();

    private CoordinateSystemRegistry() {
        this.add(PredefinedCoordinateSystems.BC_ALBERS_NAD_83);
        this.add(PredefinedCoordinateSystems.GEOGRAPHICS_WGS_84);
        this.add(CoordinateSystem.UNSPECIFIED);
        this.add(PredefinedCoordinateSystems.UTM_07N_WGS_84);
        this.add(PredefinedCoordinateSystems.UTM_08N_WGS_84);
        this.add(PredefinedCoordinateSystems.UTM_09N_WGS_84);
        this.add(PredefinedCoordinateSystems.UTM_10N_WGS_84);
        this.add(PredefinedCoordinateSystems.UTM_11N_WGS_84);
    }

    public void add(CoordinateSystem coordinateSystem) {
        this.nameToCoordinateSystemMap.put(coordinateSystem.getName(), coordinateSystem);
    }

    public Collection getCoordinateSystems() {
        return Collections.unmodifiableCollection(this.nameToCoordinateSystemMap.values());
    }

    public CoordinateSystem get(String name) {
        return (CoordinateSystem)this.nameToCoordinateSystemMap.get(name);
    }

    public static CoordinateSystemRegistry instance(Blackboard blackboard) {
        String COORDINATE_SYSTEMS_KEY = CoordinateSystemRegistry.class.getName() + " - COORDINATE SYSTEMS";
        if (blackboard.get(COORDINATE_SYSTEMS_KEY) == null) {
            blackboard.put(COORDINATE_SYSTEMS_KEY, new CoordinateSystemRegistry());
        }
        return (CoordinateSystemRegistry)blackboard.get(COORDINATE_SYSTEMS_KEY);
    }
}

