/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.feature;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.index.SpatialIndex;
import org.locationtech.jts.index.strtree.STRtree;
import org.locationtech.jts.jump.feature.Feature;
import org.locationtech.jts.jump.feature.FeatureCollection;
import org.locationtech.jts.jump.feature.FeatureCollectionWrapper;

public class IndexedFeatureCollection
extends FeatureCollectionWrapper {
    private SpatialIndex spatialIndex;

    public IndexedFeatureCollection(FeatureCollection fc) {
        this(fc, (SpatialIndex)new STRtree(10));
    }

    public IndexedFeatureCollection(FeatureCollection fc, SpatialIndex spatialIndex) {
        super(fc);
        this.spatialIndex = spatialIndex;
        this.createIndex();
    }

    @Override
    public void add(Feature feature) {
        throw new UnsupportedOperationException("Index cannot be modified");
    }

    @Override
    public void remove(Feature feature) {
        throw new UnsupportedOperationException("Index cannot be modified");
    }

    @Override
    public List query(Envelope env) {
        List candidate = this.spatialIndex.query(env);
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (Feature f : candidate) {
            Geometry g = f.getGeometry();
            if (!env.intersects(g.getEnvelopeInternal())) continue;
            result.add(f);
        }
        return result;
    }

    private void createIndex() {
        int count = 0;
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Feature f = (Feature)i.next();
            this.spatialIndex.insert(f.getGeometry().getEnvelopeInternal(), (Object)f);
            ++count;
        }
    }

    @Override
    public void addAll(Collection features) {
        throw new UnsupportedOperationException("Index cannot be modified");
    }

    @Override
    public Collection remove(Envelope env) {
        throw new UnsupportedOperationException("Index cannot be modified");
    }

    @Override
    public void removeAll(Collection features) {
        throw new UnsupportedOperationException("Index cannot be modified");
    }
}

