/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.geom;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.jump.geom.LineSegmentEnvelopeIntersector;
import org.locationtech.jts.jump.geom.MicroscopePointAdjuster;
import org.locationtech.jts.jump.util.CoordinateArrays;

public class GeometryMicroscope {
    private List geomList;
    private Envelope env;
    private double minSep;

    public GeometryMicroscope(List geomList, Envelope env, double minSep) {
        this.geomList = geomList;
        this.env = env;
        this.minSep = minSep;
    }

    public List getAdjusted() {
        List segList = this.getSegList();
        MicroscopePointAdjuster mpa = new MicroscopePointAdjuster(segList, this.env, this.minSep);
        Map ptMap = mpa.getAdjustedPointMap();
        this.applyAdjustment(ptMap);
        return this.geomList;
    }

    private void applyAdjustment(Map ptMap) {
        CoordinateAdjusterFilter coordAdjFilter = new CoordinateAdjusterFilter(ptMap);
        for (Geometry geom : this.geomList) {
            geom.apply((CoordinateFilter)coordAdjFilter);
        }
    }

    private List getSegList() {
        ArrayList segList = new ArrayList();
        for (Geometry geom : this.geomList) {
            List coordArrayList = CoordinateArrays.toCoordinateArrays(geom, false);
            this.addSegments(coordArrayList, segList);
        }
        return segList;
    }

    private void addSegments(List coordArrayList, List segList) {
        LineSegmentEnvelopeIntersector linesegEnvInt = new LineSegmentEnvelopeIntersector();
        for (Coordinate[] coord : coordArrayList) {
            for (int j = 0; j < coord.length - 1; ++j) {
                LineSegment seg = new LineSegment(coord[j], coord[j + 1]);
                if (!linesegEnvInt.touches(seg, this.env)) continue;
                segList.add(seg);
            }
        }
    }

    public class CoordinateAdjusterFilter
    implements CoordinateFilter {
        Map ptMap;

        CoordinateAdjusterFilter(Map ptMap) {
            this.ptMap = ptMap;
        }

        public void filter(Coordinate p) {
            Coordinate adj = (Coordinate)this.ptMap.get(p);
            if (adj != null) {
                p.x = adj.x;
                p.y = adj.y;
            }
        }
    }
}

