/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.geotools.dbffile.DbfFieldDef;
import org.geotools.dbffile.DbfFile;
import org.geotools.dbffile.DbfFileWriter;
import org.geotools.shapefile.Shapefile;
import org.locationtech.jts.algorithm.CGAlgorithms;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.jump.feature.AttributeType;
import org.locationtech.jts.jump.feature.Feature;
import org.locationtech.jts.jump.feature.FeatureCollection;
import org.locationtech.jts.jump.feature.FeatureSchema;
import org.locationtech.jts.jump.io.DriverProperties;
import org.locationtech.jts.jump.io.EndianDataOutputStream;
import org.locationtech.jts.jump.io.IllegalParametersException;
import org.locationtech.jts.jump.io.JUMPWriter;

public class ShapefileWriter
implements JUMPWriter {
    protected static CGAlgorithms cga = new CGAlgorithms();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void write(FeatureCollection featureCollection, DriverProperties dp) throws IllegalParametersException, Exception {
        String shpfileName = dp.getProperty("File");
        if (shpfileName == null) {
            shpfileName = dp.getProperty("DefaultValue");
        }
        if (shpfileName == null) {
            throw new IllegalParametersException("no output filename specified");
        }
        int loc = shpfileName.lastIndexOf(File.separatorChar);
        if (loc == -1) {
            throw new Exception("couldn't find the path separator character '" + File.separatorChar + "' in your shape file name. This you're probably using the unix (or dos) one.");
        }
        String path = shpfileName.substring(0, loc + 1);
        String fname = shpfileName.substring(loc + 1);
        if ((loc = fname.lastIndexOf(".")) == -1) {
            throw new IllegalParametersException("Filename must end in '.shp'");
        }
        String fname_withoutextention = fname.substring(0, loc);
        String dbffname = path + fname_withoutextention + ".dbf";
        this.writeDbf(featureCollection, dbffname);
        GeometryCollection gc = this.makeSHAPEGeometryCollection(featureCollection);
        int shapeType = 2;
        if (dp.getProperty("ShapeType") != null) {
            String st = dp.getProperty("ShapeType");
            if (st.equalsIgnoreCase("xy")) {
                shapeType = 2;
            } else if (st.equalsIgnoreCase("xym")) {
                shapeType = 3;
            } else if (st.equalsIgnoreCase("xymz")) {
                shapeType = 4;
            } else if (st.equalsIgnoreCase("xyzm")) {
                shapeType = 4;
            } else {
                if (!st.equalsIgnoreCase("xyz")) throw new IllegalParametersException("ShapefileWriter.write() - dataproperties has a 'ShapeType' that isnt 'xy', 'xym', or 'xymz'");
                shapeType = 4;
            }
        } else if (gc.getNumGeometries() > 0) {
            shapeType = this.guessCoorinateDims(gc.getGeometryN(0));
        }
        URL url = new URL("file", "localhost", shpfileName);
        Shapefile myshape = new Shapefile(url);
        myshape.write(gc, shapeType);
        String shxfname = path + fname_withoutextention + ".shx";
        BufferedOutputStream in = new BufferedOutputStream(new FileOutputStream(shxfname));
        EndianDataOutputStream sfile = new EndianDataOutputStream(in);
        myshape.writeIndex(gc, sfile, shapeType);
    }

    public int guessCoorinateDims(Geometry g) {
        Coordinate[] cs = g.getCoordinates();
        for (int t = 0; t < cs.length; ++t) {
            if (Double.isNaN(cs[t].z)) continue;
            return 4;
        }
        return 2;
    }

    void writeDbf(FeatureCollection featureCollection, String fname) throws Exception {
        int t;
        FeatureSchema fs = featureCollection.getFeatureSchema();
        DbfFieldDef[] fields = new DbfFieldDef[fs.getAttributeCount() - 1];
        int f = 0;
        for (t = 0; t < fs.getAttributeCount(); ++t) {
            AttributeType columnType = fs.getAttributeType(t);
            String columnName = fs.getAttributeName(t);
            if (columnType == AttributeType.INTEGER) {
                fields[f] = new DbfFieldDef(columnName, 'N', 16, 0);
                ++f;
                continue;
            }
            if (columnType == AttributeType.DOUBLE) {
                fields[f] = new DbfFieldDef(columnName, 'N', 33, 16);
                ++f;
                continue;
            }
            if (columnType == AttributeType.STRING) {
                int maxlength = this.findMaxStringLength(featureCollection, t);
                if (maxlength > 255) {
                    throw new Exception("ShapefileWriter does not support strings longer than 255 characters");
                }
                fields[f] = new DbfFieldDef(columnName, 'C', maxlength, 0);
                ++f;
                continue;
            }
            if (columnType == AttributeType.DATE) {
                fields[f] = new DbfFieldDef(columnName, 'D', 8, 0);
                ++f;
                continue;
            }
            if (columnType == AttributeType.GEOMETRY) continue;
            throw new Exception("Shapewriter: unsupported AttributeType found in featurecollection.");
        }
        DbfFileWriter dbf = new DbfFileWriter(fname);
        dbf.writeHeader(fields, featureCollection.size());
        int num = featureCollection.size();
        List features = featureCollection.getFeatures();
        for (t = 0; t < num; ++t) {
            Feature feature = (Feature)features.get(t);
            Vector<Object> DBFrow = new Vector<Object>();
            for (int u = 0; u < fs.getAttributeCount(); ++u) {
                Object a;
                AttributeType columnType = fs.getAttributeType(u);
                if (columnType == AttributeType.INTEGER) {
                    a = feature.getAttribute(u);
                    if (a == null) {
                        DBFrow.add(new Integer(0));
                        continue;
                    }
                    DBFrow.add((Integer)a);
                    continue;
                }
                if (columnType == AttributeType.DOUBLE) {
                    a = feature.getAttribute(u);
                    if (a == null) {
                        DBFrow.add(new Double(0.0));
                        continue;
                    }
                    DBFrow.add((Double)a);
                    continue;
                }
                if (columnType == AttributeType.DATE) {
                    a = feature.getAttribute(u);
                    if (a == null) {
                        DBFrow.add("");
                        continue;
                    }
                    DBFrow.add(DbfFile.DATE_PARSER.format((Date)a));
                    continue;
                }
                if (columnType != AttributeType.STRING) continue;
                a = feature.getAttribute(u);
                if (a == null) {
                    DBFrow.add(new String(""));
                    continue;
                }
                if (a instanceof String) {
                    DBFrow.add(a);
                    continue;
                }
                DBFrow.add(a.toString());
            }
            dbf.writeRecord(DBFrow);
        }
        dbf.close();
    }

    int findMaxStringLength(FeatureCollection fc, int attributeNumber) {
        int maxlen = 0;
        Iterator i = fc.iterator();
        while (i.hasNext()) {
            Feature f = (Feature)i.next();
            int l = f.getString(attributeNumber).length();
            if (l <= maxlen) continue;
            maxlen = l;
        }
        return maxlen;
    }

    int findBestGeometryType(FeatureCollection fc) {
        Iterator i = fc.iterator();
        while (i.hasNext()) {
            Geometry geom = ((Feature)i.next()).getGeometry();
            if (geom instanceof Point) {
                return 1;
            }
            if (geom instanceof MultiPoint) {
                return 1;
            }
            if (geom instanceof Polygon) {
                return 3;
            }
            if (geom instanceof MultiPolygon) {
                return 3;
            }
            if (geom instanceof LineString) {
                return 2;
            }
            if (!(geom instanceof MultiLineString)) continue;
            return 2;
        }
        return 0;
    }

    LinearRing reverseRing(LinearRing lr) {
        int numPoints = lr.getNumPoints();
        Coordinate[] newCoords = new Coordinate[numPoints];
        for (int t = 0; t < numPoints; ++t) {
            newCoords[t] = lr.getCoordinateN(numPoints - t - 1);
        }
        return new LinearRing(newCoords, new PrecisionModel(), 0);
    }

    Polygon makeGoodSHAPEPolygon(Polygon p) {
        LinearRing[] holes = new LinearRing[p.getNumInteriorRing()];
        Coordinate[] coords = p.getExteriorRing().getCoordinates();
        LinearRing outer = CGAlgorithms.isCCW((Coordinate[])coords) ? this.reverseRing((LinearRing)p.getExteriorRing()) : (LinearRing)p.getExteriorRing();
        for (int t = 0; t < p.getNumInteriorRing(); ++t) {
            coords = p.getInteriorRingN(t).getCoordinates();
            holes[t] = !CGAlgorithms.isCCW((Coordinate[])coords) ? this.reverseRing((LinearRing)p.getInteriorRingN(t)) : (LinearRing)p.getInteriorRingN(t);
        }
        return new Polygon(outer, holes, new PrecisionModel(), 0);
    }

    MultiPolygon makeGoodSHAPEMultiPolygon(MultiPolygon mp) {
        Polygon[] ps = new Polygon[mp.getNumGeometries()];
        for (int t = 0; t < mp.getNumGeometries(); ++t) {
            ps[t] = this.makeGoodSHAPEPolygon((Polygon)mp.getGeometryN(t));
        }
        MultiPolygon result = new MultiPolygon(ps, new PrecisionModel(), 0);
        return result;
    }

    public GeometryCollection makeSHAPEGeometryCollection(FeatureCollection fc) throws Exception {
        Geometry[] allGeoms = new Geometry[fc.size()];
        int geomtype = this.findBestGeometryType(fc);
        if (geomtype == 0) {
            throw new Exception("Could not determine shapefile type - data is either all GeometryCollections or empty");
        }
        List features = fc.getFeatures();
        block5: for (int t = 0; t < features.size(); ++t) {
            Geometry geom = ((Feature)features.get(t)).getGeometry();
            switch (geomtype) {
                case 1: {
                    Point[] p;
                    if (geom instanceof Point) {
                        p = new Point[]{(Point)geom};
                        allGeoms[t] = new MultiPoint(p, new PrecisionModel(), 0);
                        continue block5;
                    }
                    if (geom instanceof MultiPoint) {
                        allGeoms[t] = geom;
                        continue block5;
                    }
                    allGeoms[t] = new MultiPoint(null, new PrecisionModel(), 0);
                    continue block5;
                }
                case 2: {
                    if (geom instanceof LineString) {
                        LineString[] l = new LineString[]{(LineString)geom};
                        allGeoms[t] = new MultiLineString(l, new PrecisionModel(), 0);
                        continue block5;
                    }
                    if (geom instanceof MultiLineString) {
                        allGeoms[t] = geom;
                        continue block5;
                    }
                    allGeoms[t] = new MultiLineString(null, new PrecisionModel(), 0);
                    continue block5;
                }
                case 3: {
                    Point[] p;
                    if (geom instanceof Polygon) {
                        p = new Polygon[]{(Polygon)geom};
                        allGeoms[t] = this.makeGoodSHAPEMultiPolygon(new MultiPolygon((Polygon[])p, new PrecisionModel(), 0));
                        continue block5;
                    }
                    allGeoms[t] = geom instanceof MultiPolygon ? this.makeGoodSHAPEMultiPolygon((MultiPolygon)geom) : new MultiPolygon(null, new PrecisionModel(), 0);
                }
            }
        }
        GeometryCollection result = new GeometryCollection(allGeoms, new PrecisionModel(), 0);
        return result;
    }
}

