/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.io;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.locationtech.jts.jump.feature.Feature;
import org.locationtech.jts.jump.feature.FeatureCollection;
import org.locationtech.jts.jump.io.DriverProperties;
import org.locationtech.jts.jump.io.IllegalParametersException;
import org.locationtech.jts.jump.io.JUMPWriter;

public class WKTWriter
implements JUMPWriter {
    private org.locationtech.jts.io.WKTWriter wktWriter = new org.locationtech.jts.io.WKTWriter();

    @Override
    public void write(FeatureCollection featureCollection, DriverProperties dp) throws IllegalParametersException, Exception {
        String outputFname = dp.getProperty("File");
        if (outputFname == null) {
            outputFname = dp.getProperty("DefaultValue");
        }
        if (outputFname == null) {
            throw new IllegalParametersException("call to WKTWrite.write() has DataProperties w/o a OutputFile specified");
        }
        FileWriter w = new FileWriter(outputFname);
        this.write(featureCollection, w);
        ((Writer)w).close();
    }

    public void write(FeatureCollection featureCollection, Writer writer) throws IOException {
        Iterator i = featureCollection.iterator();
        while (i.hasNext()) {
            Feature feature = (Feature)i.next();
            this.wktWriter.writeFormatted(feature.getGeometry(), writer);
            if (!i.hasNext()) continue;
            writer.write("\n\n");
        }
    }
}

