/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.io.datasource;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.locationtech.jts.jump.feature.FeatureCollection;
import org.locationtech.jts.jump.io.CompressedFile;
import org.locationtech.jts.jump.io.DriverProperties;
import org.locationtech.jts.jump.io.JUMPReader;
import org.locationtech.jts.jump.util.StringUtil;
import org.locationtech.jts.jump.workbench.ui.GUIUtil;

public class DelegatingCompressedFileHandler
implements JUMPReader {
    private Collection endings;
    private JUMPReader reader;

    public DelegatingCompressedFileHandler(JUMPReader reader, Collection endings) {
        this.reader = reader;
        this.endings = new ArrayList(endings);
    }

    @Override
    public FeatureCollection read(DriverProperties dp) throws Exception {
        this.mangle(dp, "File", "CompressedFile", this.endings);
        return this.reader.read(dp);
    }

    protected void mangle(DriverProperties dp, String fileProperty, String compressedFileProperty, Collection myEndings) throws Exception {
        if (GUIUtil.getExtension(new File(dp.getProperty(fileProperty))).equalsIgnoreCase("zip")) {
            String internalName = null;
            Iterator i = myEndings.iterator();
            while (internalName == null && i.hasNext()) {
                String ending = (String)i.next();
                internalName = CompressedFile.getInternalZipFnameByExtension(ending, dp.getProperty(fileProperty));
            }
            if (internalName == null) {
                throw new Exception("Couldn't find a " + StringUtil.toCommaDelimitedString(myEndings) + " file inside the .zip file: " + dp.getProperty(fileProperty));
            }
            dp.set(compressedFileProperty, dp.getProperty(fileProperty));
            dp.set(fileProperty, internalName);
        } else if (GUIUtil.getExtension(new File(dp.getProperty(fileProperty))).equalsIgnoreCase("gz")) {
            dp.set(compressedFileProperty, dp.getProperty(fileProperty));
        }
    }
}

