/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileUtil {
    public static List getContents(String textFileName) throws FileNotFoundException, IOException {
        ArrayList<String> contents = new ArrayList<String>();
        FileReader fileReader = new FileReader(textFileName);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        String line = bufferedReader.readLine();
        while (line != null) {
            contents.add(line);
            line = bufferedReader.readLine();
        }
        return contents;
    }

    public static void setContents(String textFileName, String contents) throws IOException {
        FileWriter fileWriter = new FileWriter(textFileName, false);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        bufferedWriter.write(contents);
        bufferedWriter.flush();
        bufferedWriter.close();
        fileWriter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getContents(InputStream inputStream) throws IOException {
        ArrayList<String> contents = new ArrayList<String>();
        try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            String line = bufferedReader.readLine();
            while (line != null) {
                contents.add(line);
                line = bufferedReader.readLine();
            }
        }
        return contents;
    }

    public static void setContents(String textFileName, List lines) throws IOException {
        String contents = "";
        for (String line : lines) {
            contents = contents + line + System.getProperty("line.separator");
        }
        FileUtil.setContents(textFileName, contents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(Collection files, File zipFile) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(zipFile);
             BufferedOutputStream bos = new BufferedOutputStream(fos);
             ZipOutputStream zos = new ZipOutputStream(bos);){
            for (File file : files) {
                zos.putNextEntry(new ZipEntry(file.getName()));
                FileInputStream fis = new FileInputStream(file);
                try (BufferedInputStream bis = new BufferedInputStream(fis);){
                    int j;
                    while ((j = bis.read()) != -1) {
                        zos.write(j);
                    }
                }
                finally {
                    fis.close();
                    zos.closeEntry();
                }
            }
        }
    }
}

