/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.util.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.locationtech.jts.jump.feature.FeatureCollection;
import org.locationtech.jts.jump.feature.FeatureUtil;
import org.locationtech.jts.jump.io.FMEGMLReader;
import org.locationtech.jts.jump.io.GMLInputTemplate;
import org.locationtech.jts.jump.io.GMLReader;
import org.locationtech.jts.jump.io.ParseException;

public class SimpleGMLReader {
    public List toGeometries(Reader gml, String collectionElement, String featureElement, String geometryElement) throws Exception {
        GMLInputTemplate template = this.template(collectionElement, featureElement, geometryElement);
        GMLReader gmlReader = new GMLReader();
        gmlReader.setInputTemplate(template);
        return FeatureUtil.toGeometries(gmlReader.read(gml).getFeatures());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GMLInputTemplate template(String collectionElement, String featureElement, String geometryElement) throws IOException, ParseException {
        String s = "";
        s = s + "<?xml version='1.0' encoding='UTF-8'?>";
        s = s + "<JCSGMLInputTemplate>";
        s = s + "<CollectionElement>" + collectionElement + "</CollectionElement>";
        s = s + "<FeatureElement>" + featureElement + "</FeatureElement>";
        s = s + "<GeometryElement>" + geometryElement + "</GeometryElement>";
        s = s + "<ColumnDefinitions></ColumnDefinitions>";
        s = s + "</JCSGMLInputTemplate>";
        GMLInputTemplate template = new GMLInputTemplate();
        try (StringReader sr = new StringReader(s);){
            template.load(sr);
        }
        return template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List toGeometries(String gml, String collectionElement, String featureElement, String geometryElement) throws Exception {
        try (StringReader r = new StringReader(gml);){
            List list = this.toGeometries(r, collectionElement, featureElement, geometryElement);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FeatureCollection readFMEFile(File file) throws Exception {
        FeatureCollection fc;
        GMLInputTemplate inputTemplate;
        FMEGMLReader fmeGMLReader = new FMEGMLReader();
        try (FileReader fileReader = new FileReader(file);
             BufferedReader bufferedReader = new BufferedReader(fileReader);){
            inputTemplate = fmeGMLReader.getGMLInputTemplate(bufferedReader, file.getPath());
        }
        GMLReader gmlReader = new GMLReader();
        gmlReader.setInputTemplate(inputTemplate);
        fileReader = new FileReader(file);
        try (BufferedReader bufferedReader = new BufferedReader(fileReader);){
            fc = gmlReader.read(bufferedReader);
        }
        finally {
            fileReader.close();
        }
        return fc;
    }
}

