/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.warp;

import java.util.Map;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.jump.task.TaskMonitor;
import org.locationtech.jts.jump.warp.CoordinateTransform;
import org.locationtech.jts.jump.warp.Triangle;
import org.locationtech.jts.util.Assert;

public class BilinearInterpolatedTransform
extends CoordinateTransform {
    private Map triangleMap;
    private TaskMonitor monitor;
    private int coordinatesTransformed = 0;

    public BilinearInterpolatedTransform(Map triangleMap, TaskMonitor monitor) {
        this.triangleMap = triangleMap;
        this.monitor = monitor;
        monitor.report("Transforming...");
    }

    @Override
    public Coordinate transform(Coordinate c) {
        this.monitor.report(++this.coordinatesTransformed, -1, "coordinates");
        Triangle sourceTriangle = this.sourceTriangle(c);
        Assert.isTrue((sourceTriangle != null ? 1 : 0) != 0, (String)("Unable to determine source triangle for " + c));
        Triangle destTriangle = this.destTriangle(sourceTriangle);
        return destTriangle.toEuclideanCoordinate(sourceTriangle.toSimplicialCoordinate(c));
    }

    private Triangle sourceTriangle(Coordinate c) {
        for (Triangle triangle : this.triangleMap.keySet()) {
            if (!triangle.getEnvelope().contains(c) || !triangle.contains(c)) continue;
            return triangle;
        }
        return null;
    }

    private Triangle destTriangle(Triangle sourceTriangle) {
        return (Triangle)this.triangleMap.get(sourceTriangle);
    }
}

