/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.locationtech.jts.jump.workbench.WorkbenchProperties;
import org.locationtech.jts.jump.workbench.ui.ErrorHandler;

public class WorkbenchPropertiesFile
implements WorkbenchProperties {
    private ErrorHandler errorHandler;
    private Element root;

    public WorkbenchPropertiesFile(File file, ErrorHandler errorHandler) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        Document document = builder.build(file);
        this.root = document.getRootElement();
        this.errorHandler = errorHandler;
    }

    @Override
    public List getPlugInClasses() {
        ArrayList plugInClasses = new ArrayList();
        for (Element plugInElement : this.root.getChildren("plug-in")) {
            try {
                plugInClasses.add(Class.forName(plugInElement.getTextTrim()));
            }
            catch (ClassNotFoundException e) {
                this.errorHandler.handleThrowable(e);
            }
        }
        return plugInClasses;
    }

    @Override
    public List getInputDriverClasses() throws ClassNotFoundException {
        ArrayList inputDriverClasses = new ArrayList();
        for (Element inputDriverElement : this.root.getChildren("input-driver")) {
            inputDriverClasses.add(Class.forName(inputDriverElement.getTextTrim()));
        }
        return inputDriverClasses;
    }

    @Override
    public List getOutputDriverClasses() throws ClassNotFoundException {
        ArrayList outputDriverClasses = new ArrayList();
        for (Element outputDriverElement : this.root.getChildren("output-driver")) {
            outputDriverClasses.add(Class.forName(outputDriverElement.getTextTrim()));
        }
        return outputDriverClasses;
    }

    @Override
    public List getConfigurationClasses() throws ClassNotFoundException {
        ArrayList getConfigurationClasses = new ArrayList();
        for (Element configurationElement : this.root.getChildren("extension")) {
            getConfigurationClasses.add(Class.forName(configurationElement.getTextTrim()));
        }
        return getConfigurationClasses;
    }
}

