/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.datasource;

import javax.swing.JFileChooser;
import org.locationtech.jts.jump.io.FMEGMLReader;
import org.locationtech.jts.jump.io.FMEGMLWriter;
import org.locationtech.jts.jump.io.JMLReader;
import org.locationtech.jts.jump.io.JMLWriter;
import org.locationtech.jts.jump.io.JUMPReader;
import org.locationtech.jts.jump.io.JUMPWriter;
import org.locationtech.jts.jump.io.ShapefileReader;
import org.locationtech.jts.jump.io.ShapefileWriter;
import org.locationtech.jts.jump.io.WKTReader;
import org.locationtech.jts.jump.io.WKTWriter;
import org.locationtech.jts.jump.io.datasource.StandardReaderWriterFileDataSource;
import org.locationtech.jts.jump.workbench.WorkbenchContext;
import org.locationtech.jts.jump.workbench.datasource.DataSourceQueryChooserManager;
import org.locationtech.jts.jump.workbench.datasource.GMLDataSourceQueryChooserInstaller;
import org.locationtech.jts.jump.workbench.datasource.LoadFileDataSourceQueryChooser;
import org.locationtech.jts.jump.workbench.datasource.SaveFileDataSourceQueryChooser;
import org.locationtech.jts.jump.workbench.plugin.AbstractPlugIn;
import org.locationtech.jts.jump.workbench.plugin.PlugInContext;
import org.locationtech.jts.jump.workbench.ui.GUIUtil;
import org.locationtech.jts.util.Assert;

public class InstallStandardDataSourceQueryChoosersPlugIn
extends AbstractPlugIn {
    private void addFileDataSourceQueryChoosers(JUMPReader reader, JUMPWriter writer, final String description, WorkbenchContext context, Class readerWriterDataSourceClass) {
        DataSourceQueryChooserManager chooserManager = DataSourceQueryChooserManager.get(context.getBlackboard());
        chooserManager.addLoadDataSourceQueryChooser(new LoadFileDataSourceQueryChooser(readerWriterDataSourceClass, description, InstallStandardDataSourceQueryChoosersPlugIn.extensions(readerWriterDataSourceClass), context){

            @Override
            protected void addFileFilters(JFileChooser chooser) {
                super.addFileFilters(chooser);
                InstallStandardDataSourceQueryChoosersPlugIn.addCompressedFileFilter(description, chooser);
            }
        });
        chooserManager.addSaveDataSourceQueryChooser(new SaveFileDataSourceQueryChooser(readerWriterDataSourceClass, description, InstallStandardDataSourceQueryChoosersPlugIn.extensions(readerWriterDataSourceClass), context));
    }

    public static String[] extensions(Class readerWriterDataSourceClass) {
        String[] exts = null;
        try {
            exts = ((StandardReaderWriterFileDataSource)readerWriterDataSourceClass.newInstance()).getExtensions();
        }
        catch (Exception e) {
            Assert.shouldNeverReachHere((String)e.toString());
        }
        return exts;
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        this.addFileDataSourceQueryChoosers(new JMLReader(), new JMLWriter(), "JUMP GML", context.getWorkbenchContext(), StandardReaderWriterFileDataSource.JML.class);
        new GMLDataSourceQueryChooserInstaller().addLoadGMLFileDataSourceQueryChooser(context);
        new GMLDataSourceQueryChooserInstaller().addSaveGMLFileDataSourceQueryChooser(context);
        this.addFileDataSourceQueryChoosers(new FMEGMLReader(), new FMEGMLWriter(), "FME GML", context.getWorkbenchContext(), StandardReaderWriterFileDataSource.FMEGML.class);
        this.addFileDataSourceQueryChoosers(new WKTReader(), new WKTWriter(), "WKT", context.getWorkbenchContext(), StandardReaderWriterFileDataSource.WKT.class);
        this.addFileDataSourceQueryChoosers(new ShapefileReader(), new ShapefileWriter(), "ESRI Shapefile", context.getWorkbenchContext(), StandardReaderWriterFileDataSource.Shapefile.class);
    }

    public static void addCompressedFileFilter(String description, JFileChooser chooser) {
        chooser.addChoosableFileFilter(GUIUtil.createFileFilter("Compressed " + description, new String[]{"zip", "gz"}));
    }
}

