/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.datasource;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import org.locationtech.jts.jump.io.datasource.Connection;
import org.locationtech.jts.jump.io.datasource.DataSourceQuery;
import org.locationtech.jts.jump.task.TaskMonitor;
import org.locationtech.jts.jump.workbench.WorkbenchContext;
import org.locationtech.jts.jump.workbench.datasource.DataSourceQueryChooserDialog;
import org.locationtech.jts.jump.workbench.datasource.DataSourceQueryChooserManager;
import org.locationtech.jts.jump.workbench.plugin.EnableCheckFactory;
import org.locationtech.jts.jump.workbench.plugin.MultiEnableCheck;
import org.locationtech.jts.jump.workbench.plugin.PlugInContext;
import org.locationtech.jts.jump.workbench.plugin.ThreadedBasePlugIn;
import org.locationtech.jts.jump.workbench.ui.GUIUtil;
import org.locationtech.jts.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import org.locationtech.jts.util.Assert;

public class SaveDatasetAsPlugIn
extends ThreadedBasePlugIn {
    private static String LAST_FORMAT_KEY = SaveDatasetAsPlugIn.class.getName() + " - LAST FORMAT";

    private DataSourceQueryChooserDialog getDialog(PlugInContext context) {
        String KEY = this.getClass().getName() + " - DIALOG";
        if (null == context.getWorkbenchContext().getWorkbench().getBlackboard().get(KEY)) {
            context.getWorkbenchContext().getWorkbench().getBlackboard().put(KEY, new DataSourceQueryChooserDialog(DataSourceQueryChooserManager.get(context.getWorkbenchContext().getWorkbench().getBlackboard()).getSaveDataSourceQueryChoosers(), context.getWorkbenchFrame(), this.getName(), true));
        }
        return (DataSourceQueryChooserDialog)context.getWorkbenchContext().getWorkbench().getBlackboard().get(KEY);
    }

    @Override
    public void initialize(final PlugInContext context) throws Exception {
        context.getWorkbenchFrame().addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                String format = (String)PersistentBlackboardPlugIn.get(context.getWorkbenchContext()).get(LAST_FORMAT_KEY);
                if (format != null) {
                    SaveDatasetAsPlugIn.this.getDialog(context).setSelectedFormat(format);
                }
            }
        });
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        GUIUtil.centreOnWindow(this.getDialog(context));
        this.getDialog(context).setVisible(true);
        if (this.getDialog(context).wasOKPressed()) {
            PersistentBlackboardPlugIn.get(context.getWorkbenchContext()).put(LAST_FORMAT_KEY, this.getDialog(context).getSelectedFormat());
        }
        return this.getDialog(context).wasOKPressed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        Assert.isTrue((this.getDialog(context).getCurrentChooser().getDataSourceQueries().size() == 1 ? 1 : 0) != 0);
        DataSourceQuery dataSourceQuery = (DataSourceQuery)this.getDialog(context).getCurrentChooser().getDataSourceQueries().iterator().next();
        Assert.isTrue((boolean)dataSourceQuery.getDataSource().isWritable());
        monitor.report("Saving " + dataSourceQuery.toString() + "...");
        try (Connection connection = dataSourceQuery.getDataSource().getConnection();){
            connection.executeUpdate(dataSourceQuery.getQuery(), context.getSelectedLayer(0).getFeatureCollectionWrapper(), monitor);
        }
        context.getSelectedLayer(0).setDataSourceQuery(dataSourceQuery).setFeatureCollectionModified(false);
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createExactlyNLayersMustBeSelectedCheck(1));
    }
}

