/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.driver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.locationtech.jts.jump.workbench.WorkbenchProperties;
import org.locationtech.jts.jump.workbench.driver.AbstractDriver;
import org.locationtech.jts.jump.workbench.driver.AbstractInputDriver;
import org.locationtech.jts.jump.workbench.driver.AbstractOutputDriver;
import org.locationtech.jts.jump.workbench.driver.FMEFileInputDriver;
import org.locationtech.jts.jump.workbench.driver.FMEFileOutputDriver;
import org.locationtech.jts.jump.workbench.driver.GMLFileInputDriver;
import org.locationtech.jts.jump.workbench.driver.GMLFileOutputDriver;
import org.locationtech.jts.jump.workbench.driver.JMLFileInputDriver;
import org.locationtech.jts.jump.workbench.driver.JMLFileOutputDriver;
import org.locationtech.jts.jump.workbench.driver.ShapeFileInputDriver;
import org.locationtech.jts.jump.workbench.driver.ShapefileOutputDriver;
import org.locationtech.jts.jump.workbench.driver.WKTFileInputDriver;
import org.locationtech.jts.jump.workbench.driver.WKTFileOutputDriver;
import org.locationtech.jts.jump.workbench.ui.BasicFileDriverPanel;
import org.locationtech.jts.jump.workbench.ui.ErrorHandler;
import org.locationtech.jts.util.Assert;

public class DriverManager {
    private ArrayList inputDrivers = new ArrayList();
    private ArrayList outputDrivers = new ArrayList();
    private List builtInInputDriverClasses = Arrays.asList(FMEFileInputDriver.class, GMLFileInputDriver.class, JMLFileInputDriver.class, ShapeFileInputDriver.class, WKTFileInputDriver.class);
    private List builtInOutputDriverClasses = Arrays.asList(FMEFileOutputDriver.class, GMLFileOutputDriver.class, JMLFileOutputDriver.class, ShapefileOutputDriver.class, WKTFileOutputDriver.class);
    private BasicFileDriverPanel sharedOpenBasicFileDriverPanel;
    private BasicFileDriverPanel sharedSaveBasicFileDriverPanel;
    private ErrorHandler errorHandler;

    public DriverManager(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        this.sharedOpenBasicFileDriverPanel = new SharedFileDriverPanel("File To Open", errorHandler);
        this.sharedSaveBasicFileDriverPanel = new SharedFileDriverPanel("File To Save", errorHandler);
        this.sharedOpenBasicFileDriverPanel.setFileMustExist(true);
        this.sharedSaveBasicFileDriverPanel.setFileMustExist(false);
    }

    public List getInputDrivers() {
        return this.inputDrivers;
    }

    public List getOutputDrivers() {
        return this.outputDrivers;
    }

    public BasicFileDriverPanel getSharedOpenBasicFileDriverPanel() {
        return this.sharedOpenBasicFileDriverPanel;
    }

    public BasicFileDriverPanel getSharedSaveBasicFileDriverPanel() {
        return this.sharedSaveBasicFileDriverPanel;
    }

    public void loadDrivers(WorkbenchProperties properties) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        ArrayList newInputDriverClasses = new ArrayList();
        newInputDriverClasses.addAll(this.builtInInputDriverClasses);
        newInputDriverClasses.addAll(properties.getInputDriverClasses());
        this.loadDrivers(newInputDriverClasses, this.inputDrivers);
        ArrayList newOutputDriverClasses = new ArrayList();
        newOutputDriverClasses.addAll(this.builtInOutputDriverClasses);
        newOutputDriverClasses.addAll(properties.getOutputDriverClasses());
        this.loadDrivers(newOutputDriverClasses, this.outputDrivers);
    }

    public void loadInputDriver(AbstractInputDriver driver) {
        driver.initialize(this, this.errorHandler);
        this.inputDrivers.add(driver);
    }

    public void loadOutputDriver(AbstractOutputDriver driver) {
        driver.initialize(this, this.errorHandler);
        this.outputDrivers.add(driver);
    }

    private void loadDrivers(List driverClasses, List drivers) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        for (Class driverClass : driverClasses) {
            AbstractDriver driver = (AbstractDriver)driverClass.newInstance();
            driver.initialize(this, this.errorHandler);
            drivers.add(driver);
        }
    }

    private static class SharedFileDriverPanel
    extends BasicFileDriverPanel {
        public SharedFileDriverPanel(String description, ErrorHandler errorHandler) {
            super(errorHandler);
            this.fileNamePanel.setUpperDescription(description);
        }

        @Override
        public void setFileDescription(String description) {
            Assert.shouldNeverReachHere((String)"Panel is shared; thus description cannot be changed");
        }
    }
}

