/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.driver;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.locationtech.jts.jump.feature.FeatureCollection;
import org.locationtech.jts.jump.io.CompressedFile;
import org.locationtech.jts.jump.io.DriverProperties;
import org.locationtech.jts.jump.io.IllegalParametersException;
import org.locationtech.jts.jump.io.JMLReader;
import org.locationtech.jts.jump.io.ParseException;
import org.locationtech.jts.jump.workbench.driver.AbstractInputDriver;
import org.locationtech.jts.jump.workbench.driver.DriverManager;
import org.locationtech.jts.jump.workbench.model.Layer;
import org.locationtech.jts.jump.workbench.model.LayerManager;
import org.locationtech.jts.jump.workbench.ui.AbstractDriverPanel;
import org.locationtech.jts.jump.workbench.ui.BasicFileDriverPanel;
import org.locationtech.jts.jump.workbench.ui.ErrorHandler;
import org.locationtech.jts.jump.workbench.ui.GUIUtil;
import org.locationtech.jts.jump.workbench.ui.WorkbenchFileFilter;

public class JMLFileInputDriver
extends AbstractInputDriver {
    private BasicFileDriverPanel panel;
    private DriverProperties dp = new DriverProperties();

    @Override
    public String toString() {
        return "JCS GML";
    }

    @Override
    public AbstractDriverPanel getPanel() {
        return this.panel;
    }

    @Override
    public void initialize(DriverManager driverManager, ErrorHandler errorHandler) {
        super.initialize(driverManager, errorHandler);
        this.panel = new BasicFileDriverPanel(errorHandler);
        this.panel.setFileDescription("JCS GML");
        this.panel.setFileFilter(new WorkbenchFileFilter("JCS GML"));
        this.panel.setFileMustExist(true);
    }

    @Override
    public void input(LayerManager layerManager, String categoryName) throws FileNotFoundException, IOException, ParseException, org.locationtech.jts.io.ParseException, IllegalParametersException, Exception {
        File selectedFile = this.panel.getSelectedFile();
        JMLReader jmlReader = new JMLReader();
        String name = selectedFile.getAbsolutePath();
        String extension = name.substring(name.length() - 3);
        this.dp = new DriverProperties();
        if (extension.equalsIgnoreCase("zip")) {
            this.dp.set("CompressedFile", name);
            String internalName = CompressedFile.getInternalZipFnameByExtension(".jml", name);
            if (internalName == null) {
                internalName = CompressedFile.getInternalZipFnameByExtension(".gml", name);
            }
            if (internalName == null) {
                internalName = CompressedFile.getInternalZipFnameByExtension(".xml", name);
            }
            if (internalName == null) {
                throw new Exception("Couldnt find a .jml, .xml, or .gml file inside the .zip file: " + name);
            }
            this.dp.set("File", internalName);
        } else if (extension.equalsIgnoreCase(".gz")) {
            this.dp.set("CompressedFile", name);
            this.dp.set("File", name);
        } else {
            this.dp.set("File", name);
        }
        FeatureCollection featureCollection = jmlReader.read(this.dp);
        Layer layer = layerManager.addLayer(categoryName, GUIUtil.nameWithoutExtension(selectedFile), featureCollection);
    }
}

