/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.driver;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.locationtech.jts.jump.feature.FeatureCollection;
import org.locationtech.jts.jump.io.CompressedFile;
import org.locationtech.jts.jump.io.DriverProperties;
import org.locationtech.jts.jump.io.IllegalParametersException;
import org.locationtech.jts.jump.io.ParseException;
import org.locationtech.jts.jump.io.ShapefileReader;
import org.locationtech.jts.jump.workbench.driver.AbstractInputDriver;
import org.locationtech.jts.jump.workbench.driver.DriverManager;
import org.locationtech.jts.jump.workbench.model.Layer;
import org.locationtech.jts.jump.workbench.model.LayerManager;
import org.locationtech.jts.jump.workbench.ui.AbstractDriverPanel;
import org.locationtech.jts.jump.workbench.ui.BasicFileDriverPanel;
import org.locationtech.jts.jump.workbench.ui.ErrorHandler;
import org.locationtech.jts.jump.workbench.ui.GUIUtil;
import org.locationtech.jts.jump.workbench.ui.WorkbenchFileFilter;

public class ShapeFileInputDriver
extends AbstractInputDriver {
    private ShapefileReader reader = new ShapefileReader();
    private BasicFileDriverPanel panel;

    @Override
    public String toString() {
        return "ESRI Shapefile";
    }

    @Override
    public AbstractDriverPanel getPanel() {
        return this.panel;
    }

    @Override
    public void input(LayerManager layerManager, String categoryName) throws FileNotFoundException, IOException, ParseException, ParseException, IllegalParametersException, Exception {
        File selectedFile = this.panel.getSelectedFile();
        String name = GUIUtil.nameWithoutExtension(selectedFile);
        String fname = selectedFile.getAbsolutePath();
        String extension = fname.substring(fname.length() - 3);
        DriverProperties dp = new DriverProperties();
        if (extension.equalsIgnoreCase("zip")) {
            dp.set("CompressedFile", fname);
            String internalName = CompressedFile.getInternalZipFnameByExtension(".shp", fname);
            if (internalName == null) {
                throw new Exception("Couldnt find a .shp file inside the .zip file: " + fname);
            }
            dp.set("File", internalName);
        } else {
            dp.set("File", fname);
        }
        FeatureCollection featureCollection = this.reader.read(dp);
        Layer layer = layerManager.addLayer(categoryName, name, featureCollection);
    }

    @Override
    public void initialize(DriverManager driverManager, ErrorHandler errorHandler) {
        super.initialize(driverManager, errorHandler);
        this.panel = new BasicFileDriverPanel(errorHandler);
        this.panel.setFileDescription("ESRI Shapefile");
        this.panel.setFileFilter(new WorkbenchFileFilter("ESRI Shapefile"));
        this.panel.setFileMustExist(true);
    }
}

