/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.model;

import java.awt.Color;
import org.locationtech.jts.jump.feature.AttributeType;
import org.locationtech.jts.jump.feature.FeatureDataset;
import org.locationtech.jts.jump.feature.FeatureSchema;
import org.locationtech.jts.jump.workbench.model.Layer;
import org.locationtech.jts.jump.workbench.model.LayerManagerProxy;

public abstract class SystemLayerFinder {
    private String layerName;
    private LayerManagerProxy layerManagerProxy;

    public SystemLayerFinder(String layerName, LayerManagerProxy layerManagerProxy) {
        this.layerManagerProxy = layerManagerProxy;
        this.layerName = layerName;
    }

    public String getLayerName() {
        return this.layerName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Layer createLayer() {
        FeatureSchema schema = new FeatureSchema();
        schema.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        FeatureDataset dataset = new FeatureDataset(schema);
        Layer layer = new Layer(this.layerName, Color.blue, dataset, this.layerManagerProxy.getLayerManager()){

            @Override
            public boolean isFeatureCollectionModified() {
                return false;
            }
        };
        boolean firingEvents = this.layerManagerProxy.getLayerManager().isFiringEvents();
        this.layerManagerProxy.getLayerManager().setFiringEvents(false);
        try {
            this.applyStyles(layer);
        }
        finally {
            this.layerManagerProxy.getLayerManager().setFiringEvents(firingEvents);
        }
        this.layerManagerProxy.getLayerManager().addLayer("System", layer);
        return layer;
    }

    public Layer getLayer() {
        Layer layer = this.layerManagerProxy.getLayerManager().getLayer(this.layerName);
        if (layer == null) {
            return null;
        }
        return layer;
    }

    protected abstract void applyStyles(Layer var1);
}

