/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.locationtech.jts.jump.feature.Feature;
import org.locationtech.jts.jump.workbench.WorkbenchContext;
import org.locationtech.jts.jump.workbench.model.CategoryEvent;
import org.locationtech.jts.jump.workbench.model.FeatureEvent;
import org.locationtech.jts.jump.workbench.model.Layer;
import org.locationtech.jts.jump.workbench.model.LayerEvent;
import org.locationtech.jts.jump.workbench.model.LayerEventType;
import org.locationtech.jts.jump.workbench.model.LayerListener;
import org.locationtech.jts.jump.workbench.model.LayerManager;
import org.locationtech.jts.jump.workbench.model.LayerManagerProxy;
import org.locationtech.jts.jump.workbench.model.Layerable;
import org.locationtech.jts.jump.workbench.plugin.EnableCheck;
import org.locationtech.jts.jump.workbench.plugin.MultiEnableCheck;
import org.locationtech.jts.jump.workbench.plugin.PlugIn;
import org.locationtech.jts.jump.workbench.plugin.PlugInContext;
import org.locationtech.jts.jump.workbench.ui.AttributePanel;
import org.locationtech.jts.jump.workbench.ui.AttributeTablePanel;
import org.locationtech.jts.jump.workbench.ui.EnableableToolBar;
import org.locationtech.jts.jump.workbench.ui.ErrorHandler;
import org.locationtech.jts.jump.workbench.ui.GUIUtil;
import org.locationtech.jts.jump.workbench.ui.InfoModel;
import org.locationtech.jts.jump.workbench.ui.InfoModelListener;
import org.locationtech.jts.jump.workbench.ui.LayerNamePanel;
import org.locationtech.jts.jump.workbench.ui.LayerNamePanelListener;
import org.locationtech.jts.jump.workbench.ui.LayerTableModel;
import org.locationtech.jts.jump.workbench.ui.TaskFrame;
import org.locationtech.jts.jump.workbench.ui.TitledPopupMenu;
import org.locationtech.jts.jump.workbench.ui.TreeLayerNamePanel;
import org.locationtech.jts.jump.workbench.ui.cursortool.FeatureInfoTool;
import org.locationtech.jts.jump.workbench.ui.images.IconLoader;
import org.locationtech.jts.jump.workbench.ui.plugin.FeatureInfoPlugIn;
import org.locationtech.jts.jump.workbench.ui.plugin.FeatureInstaller;

public class AttributeTab
extends JPanel
implements LayerNamePanel {
    private BorderLayout borderLayout1 = new BorderLayout();
    private ErrorHandler errorHandler;
    private TaskFrame taskFrame;
    private LayerManagerProxy layerManagerProxy;
    private EnableCheck taskFrameEnableCheck = new EnableCheck(){

        @Override
        public String check(JComponent component) {
            return !AttributeTab.this.taskFrame.isVisible() ? "Task frame must be open" : null;
        }
    };
    private EnableCheck layersEnableCheck = new EnableCheck(){

        @Override
        public String check(JComponent component) {
            return AttributeTab.this.panel.getModel().getLayers().isEmpty() ? "One or more layers must be present" : null;
        }
    };
    private AttributePanel panel;
    private JScrollPane scrollPane = new JScrollPane();
    private EnableCheck rowsSelectedEnableCheck = new EnableCheck(){

        @Override
        public String check(JComponent component) {
            return AttributeTab.this.panel.selectedFeatures().isEmpty() ? "One or more rows must be selected" : null;
        }
    };
    private EnableableToolBar toolBar = new EnableableToolBar();
    private InfoModel model;
    private Layer[] selectedLayers = new Layer[0];
    private Layer[] lastSelectedLayers = new Layer[0];

    public InfoModel getModel() {
        return this.model;
    }

    public AttributeTab(InfoModel model, final WorkbenchContext workbenchContext, TaskFrame taskFrame, LayerManagerProxy layerManagerProxy) {
        this.layerManagerProxy = layerManagerProxy;
        this.model = model;
        this.taskFrame = taskFrame;
        taskFrame.addInternalFrameListener(GUIUtil.toInternalFrameListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttributeTab.this.toolBar.updateEnabledState();
            }
        }));
        this.panel = new AttributePanel(model, workbenchContext, taskFrame, layerManagerProxy){

            @Override
            public void layerAdded(LayerTableModel layerTableModel) {
                super.layerAdded(layerTableModel);
                final AttributeTablePanel tablePanel = this.getTablePanel(layerTableModel.getLayer());
                MouseAdapter mouseListener = new MouseAdapter(){

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        if (!SwingUtilities.isRightMouseButton(e)) {
                            return;
                        }
                        AttributeTab.popupMenu(workbenchContext).setTitle(tablePanel.getModel().getLayer().getName());
                        AttributeTab.access$302(AttributeTab.this, new Layer[]{tablePanel.getModel().getLayer()});
                        AttributeTab.setEnableLastSelectedLayers(true, AttributeTab.this);
                        try {
                            AttributeTab.popupMenu(workbenchContext).show(tablePanel.getLayerNameRenderer(), e.getX(), e.getY());
                        }
                        finally {
                            AttributeTab.setEnableLastSelectedLayers(false, AttributeTab.this);
                        }
                    }
                };
                tablePanel.addMouseListener(mouseListener);
                tablePanel.getTable().addMouseListener(mouseListener);
                tablePanel.getTable().getTableHeader().addMouseListener(mouseListener);
                tablePanel.getLayerNameRenderer().addMouseListener(mouseListener);
            }
        };
        layerManagerProxy.getLayerManager().addLayerListener(new LayerListener(){

            @Override
            public void featuresChanged(FeatureEvent e) {
            }

            @Override
            public void layerChanged(LayerEvent e) {
                if (e.getType() == LayerEventType.METADATA_CHANGED) {
                    AttributeTab.this.toolBar.updateEnabledState();
                }
            }

            @Override
            public void categoryChanged(CategoryEvent e) {
            }
        });
        model.addListener(new InfoModelListener(){

            @Override
            public void layerAdded(LayerTableModel layerTableModel) {
                AttributeTab.this.panel.getTablePanel(layerTableModel.getLayer()).getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        AttributeTab.this.toolBar.updateEnabledState();
                    }
                });
                AttributeTab.this.toolBar.updateEnabledState();
            }

            @Override
            public void layerRemoved(LayerTableModel layerTableModel) {
                AttributeTab.this.toolBar.updateEnabledState();
            }
        });
        this.errorHandler = workbenchContext.getErrorHandler();
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.initScrollPane();
        this.installToolBarButtons(workbenchContext, taskFrame);
        this.toolBar.updateEnabledState();
    }

    private void installToolBarButtons(WorkbenchContext workbenchContext, final TaskFrame taskFrame) {
        this.toolBar.add(new JButton(), "Zoom To Previous Row", IconLoader.icon("SmallUp.gif"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AttributeTab.this.zoom(AttributeTab.this.panel.topSelectedRow().previousRow());
                }
                catch (Throwable t) {
                    AttributeTab.this.errorHandler.handleThrowable(t);
                }
            }
        }, new MultiEnableCheck().add(this.taskFrameEnableCheck).add(this.layersEnableCheck));
        this.toolBar.add(new JButton(), "Zoom To Next Row", IconLoader.icon("SmallDown.gif"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AttributeTab.this.zoom(AttributeTab.this.panel.topSelectedRow().nextRow());
                }
                catch (Throwable t) {
                    AttributeTab.this.errorHandler.handleThrowable(t);
                }
            }
        }, new MultiEnableCheck().add(this.taskFrameEnableCheck).add(this.layersEnableCheck));
        this.toolBar.add(new JButton(), "Zoom To Selected Rows", IconLoader.icon("SmallMagnify.gif"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AttributeTab.this.panel.zoom(AttributeTab.this.panel.selectedFeatures());
                }
                catch (Throwable t) {
                    AttributeTab.this.errorHandler.handleThrowable(t);
                }
            }
        }, new MultiEnableCheck().add(this.taskFrameEnableCheck).add(this.layersEnableCheck).add(this.rowsSelectedEnableCheck));
        this.toolBar.add(new JButton(), "Zoom To Full Extent", IconLoader.icon("SmallWorld.gif"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    taskFrame.getLayerViewPanel().getViewport().zoomToFullExtent();
                }
                catch (Throwable t) {
                    AttributeTab.this.errorHandler.handleThrowable(t);
                }
            }
        }, new MultiEnableCheck().add(this.taskFrameEnableCheck).add(this.layersEnableCheck));
        this.toolBar.add(new JButton(), "Select In Task Window", IconLoader.icon("SmallSelect.gif"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AttributeTab.this.panel.selectInLayerViewPanel();
                }
                catch (Throwable t) {
                    AttributeTab.this.errorHandler.handleThrowable(t);
                }
            }
        }, new MultiEnableCheck().add(this.taskFrameEnableCheck).add(this.layersEnableCheck).add(this.rowsSelectedEnableCheck));
        this.toolBar.add(new JButton(), "Flash Selected Rows", IconLoader.icon("Flashlight.gif"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AttributeTab.this.panel.flashSelectedFeatures();
                }
                catch (Throwable t) {
                    AttributeTab.this.errorHandler.handleThrowable(t);
                }
            }
        }, new MultiEnableCheck().add(this.taskFrameEnableCheck).add(this.layersEnableCheck).add(this.rowsSelectedEnableCheck));
        FeatureInfoPlugIn featureInfoPlugIn = new FeatureInfoPlugIn();
        this.toolBar.add(new JButton(), featureInfoPlugIn.getName(), GUIUtil.toSmallIcon(FeatureInfoTool.ICON), FeatureInfoPlugIn.toActionListener(featureInfoPlugIn, workbenchContext, null), FeatureInfoPlugIn.createEnableCheck(workbenchContext));
    }

    public TaskFrame getTaskFrame() {
        return this.taskFrame;
    }

    @Override
    public Layer chooseEditableLayer() {
        return TreeLayerNamePanel.chooseEditableLayer(this);
    }

    @Override
    public LayerManager getLayerManager() {
        return this.layerManagerProxy.getLayerManager();
    }

    void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.toolBar.setOrientation(1);
        this.scrollPane.getViewport().add((Component)this.panel, null);
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)this.toolBar, "West");
    }

    private void initScrollPane() {
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(new JTable().getRowHeight());
    }

    private void zoom(AttributePanel.Row row) throws NoninvertibleTransformException {
        this.panel.clearSelection();
        row.getPanel().getTable().getSelectionModel().setSelectionInterval(row.getIndex(), row.getIndex());
        Rectangle r = row.getPanel().getTable().getCellRect(row.getIndex(), 0, true);
        row.getPanel().getTable().scrollRectToVisible(r);
        if (row.isFirstRow()) {
            row.getPanel().scrollRectToVisible(new Rectangle(0, 0, 1, 1));
        }
        ArrayList<Feature> features = new ArrayList<Feature>();
        features.add(row.getFeature());
        this.panel.zoom(features);
    }

    public static TitledPopupMenu popupMenu(WorkbenchContext context) {
        return (TitledPopupMenu)context.getWorkbench().getBlackboard().get(AttributeTab.class.getName() + " - LAYER POPUP MENU", new TitledPopupMenu());
    }

    public static void addPopupMenuItem(WorkbenchContext workbenchContext, PlugIn plugIn, String menuItemName, boolean checkBox, Icon icon, EnableCheck enableCheck) {
        new FeatureInstaller(workbenchContext).addPopupMenuItem(AttributeTab.popupMenu(workbenchContext), AttributeTab.wrap(plugIn), menuItemName, checkBox, icon, enableCheck);
    }

    private static PlugIn wrap(final PlugIn plugIn) {
        return new PlugIn(){

            @Override
            public void initialize(PlugInContext context) throws Exception {
                plugIn.initialize(context);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean execute(PlugInContext context) throws Exception {
                AttributeTab attributeTab = (AttributeTab)context.getLayerNamePanel();
                AttributeTab.setEnableLastSelectedLayers(true, attributeTab);
                try {
                    boolean bl = plugIn.execute(context);
                    return bl;
                }
                finally {
                    AttributeTab.setEnableLastSelectedLayers(false, attributeTab);
                }
            }

            @Override
            public String getName() {
                return plugIn.getName();
            }
        };
    }

    private static void setEnableLastSelectedLayers(boolean enabled, AttributeTab attributeTab) {
        attributeTab.selectedLayers = enabled ? attributeTab.lastSelectedLayers : new Layer[]{};
    }

    @Override
    public Collection getSelectedCategories() {
        return new ArrayList();
    }

    @Override
    public Layer[] getSelectedLayers() {
        if (this.model.getLayers().size() == 1) {
            return new Layer[]{(Layer)this.model.getLayers().get(0)};
        }
        return this.selectedLayers;
    }

    @Override
    public Collection selectedNodes(Class c) {
        if (!Layerable.class.isAssignableFrom(c)) {
            return new ArrayList();
        }
        return Arrays.asList(this.getSelectedLayers());
    }

    public AttributePanel getPanel() {
        return this.panel;
    }

    public EnableableToolBar getToolBar() {
        return this.toolBar;
    }

    @Override
    public void addListener(LayerNamePanelListener listener) {
    }

    @Override
    public void removeListener(LayerNamePanelListener listener) {
    }

    @Override
    public void dispose() {
    }

    static /* synthetic */ Layer[] access$302(AttributeTab x0, Layer[] x1) {
        x0.lastSelectedLayers = x1;
        return x1;
    }
}

