/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.locationtech.jts.jump.util.OrderedMap;
import org.locationtech.jts.jump.workbench.model.Layer;
import org.locationtech.jts.jump.workbench.ui.InfoModelListener;
import org.locationtech.jts.jump.workbench.ui.LayerTableModel;

public class InfoModel {
    private OrderedMap layerToTableModelMap = new OrderedMap();
    private ArrayList listeners = new ArrayList();

    public void dispose() {
        for (Layer layer : new ArrayList(this.getLayers())) {
            this.remove(layer);
        }
    }

    public Collection getLayerTableModels() {
        return Collections.unmodifiableCollection(this.layerToTableModelMap.values());
    }

    public void add(Layer layer, Collection features) {
        boolean layerNew = !this.layerToTableModelMap.containsKey(layer);
        LayerTableModel layerTableModel = this.getTableModel(layer);
        layerTableModel.addAll(features);
        if (layerNew) {
            for (InfoModelListener listener : this.listeners) {
                listener.layerAdded(layerTableModel);
            }
        }
    }

    public void remove(Layer layer) {
        LayerTableModel layerTableModel = this.getTableModel(layer);
        ((LayerTableModel)this.layerToTableModelMap.get(layer)).dispose();
        this.layerToTableModelMap.remove(layer);
        for (InfoModelListener listener : this.listeners) {
            listener.layerRemoved(layerTableModel);
        }
    }

    public void clear() {
        ArrayList layers = new ArrayList(this.layerToTableModelMap.keySet());
        for (Layer layer : layers) {
            this.remove(layer);
        }
    }

    public LayerTableModel getTableModel(Layer layer) {
        if (!this.layerToTableModelMap.containsKey(layer)) {
            this.layerToTableModelMap.put(layer, new LayerTableModel(layer));
        }
        return (LayerTableModel)this.layerToTableModelMap.get(layer);
    }

    public List getLayers() {
        return Collections.unmodifiableList(this.layerToTableModelMap.keyList());
    }

    public void addListener(InfoModelListener listener) {
        this.listeners.add(listener);
    }
}

