/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.locationtech.jts.jump.workbench.model.Category;
import org.locationtech.jts.jump.workbench.model.LayerTreeModel;
import org.locationtech.jts.jump.workbench.model.Layerable;
import org.locationtech.jts.jump.workbench.ui.LayerNameRenderer;
import org.locationtech.jts.jump.workbench.ui.renderer.RenderingManager;
import org.locationtech.jts.util.Assert;

public class LayerTreeCellRenderer
implements TreeCellRenderer {
    private LayerNameRenderer layerNameRenderer = new LayerNameRenderer();
    private JLabel rootRendererComponent = new JLabel("Root");
    private DefaultTreeCellRenderer categoryRenderer = new DefaultTreeCellRenderer();

    public LayerTreeCellRenderer(RenderingManager renderingManager) {
        this.layerNameRenderer.setCheckBoxVisible(true);
        this.layerNameRenderer.setIndicatingEditability(true);
        this.layerNameRenderer.setIndicatingProgress(true, renderingManager);
    }

    public LayerNameRenderer getLayerNameRenderer() {
        return this.layerNameRenderer;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Object node = value;
        if (node instanceof LayerTreeModel.Root) {
            return this.getTreeCellRendererComponent((LayerTreeModel.Root)node);
        }
        if (node instanceof Category) {
            this.categoryRenderer.setBackgroundNonSelectionColor(tree.getBackground());
            JLabel categoryRendererComponent = (JLabel)this.categoryRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            categoryRendererComponent.setFont(new JLabel().getFont().deriveFont(1));
            categoryRendererComponent.setText(((Category)node).getName());
            if (expanded) {
                categoryRendererComponent.setIcon(UIManager.getIcon("Tree.openIcon"));
            } else {
                categoryRendererComponent.setIcon(UIManager.getIcon("Tree.closedIcon"));
            }
            return categoryRendererComponent;
        }
        if (node instanceof Layerable) {
            return this.layerNameRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        }
        Assert.shouldNeverReachHere((String)node.getClass().toString());
        return null;
    }

    private Component getTreeCellRendererComponent(LayerTreeModel.Root root) {
        return this.rootRendererComponent;
    }
}

