/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.jump.feature.Feature;
import org.locationtech.jts.jump.util.Blackboard;
import org.locationtech.jts.jump.workbench.model.CategoryEvent;
import org.locationtech.jts.jump.workbench.model.FeatureEvent;
import org.locationtech.jts.jump.workbench.model.FenceLayerFinder;
import org.locationtech.jts.jump.workbench.model.Layer;
import org.locationtech.jts.jump.workbench.model.LayerEvent;
import org.locationtech.jts.jump.workbench.model.LayerEventType;
import org.locationtech.jts.jump.workbench.model.LayerListener;
import org.locationtech.jts.jump.workbench.model.LayerManager;
import org.locationtech.jts.jump.workbench.model.LayerManagerProxy;
import org.locationtech.jts.jump.workbench.ui.GUIUtil;
import org.locationtech.jts.jump.workbench.ui.LayerViewPanelContext;
import org.locationtech.jts.jump.workbench.ui.LayerViewPanelListener;
import org.locationtech.jts.jump.workbench.ui.SelectionManager;
import org.locationtech.jts.jump.workbench.ui.SelectionManagerProxy;
import org.locationtech.jts.jump.workbench.ui.ToolTipWriter;
import org.locationtech.jts.jump.workbench.ui.TrackedPopupMenu;
import org.locationtech.jts.jump.workbench.ui.Viewport;
import org.locationtech.jts.jump.workbench.ui.WorkbenchFrame;
import org.locationtech.jts.jump.workbench.ui.cursortool.CursorTool;
import org.locationtech.jts.jump.workbench.ui.cursortool.DummyTool;
import org.locationtech.jts.jump.workbench.ui.renderer.RenderingManager;
import org.locationtech.jts.jump.workbench.ui.renderer.java2D.Java2DConverter;
import org.locationtech.jts.jump.workbench.ui.renderer.style.PinEqualCoordinatesStyle;
import org.locationtech.jts.util.Assert;

public class LayerViewPanel
extends JPanel
implements LayerListener,
LayerManagerProxy,
SelectionManagerProxy {
    private static JPopupMenu popupMenu = new TrackedPopupMenu();
    private ToolTipWriter toolTipWriter = new ToolTipWriter(this);
    BorderLayout borderLayout1 = new BorderLayout();
    private LayerManager layerManager;
    private CursorTool currentCursorTool = new DummyTool();
    private Viewport viewport = new Viewport(this);
    private boolean viewportInitialized = false;
    private Point lastClickedPoint;
    private ArrayList listeners = new ArrayList();
    private LayerViewPanelContext context;
    private RenderingManager renderingManager = new RenderingManager(this);
    private FenceLayerFinder fenceLayerFinder;
    private SelectionManager selectionManager;
    private Blackboard blackboard = new Blackboard();

    public LayerViewPanel(LayerManager layerManager, LayerViewPanelContext context) {
        this.setMinimumSize(new Dimension(100, 100));
        this.setToolTipText("");
        GUIUtil.fixClicks(this);
        try {
            this.context = context;
            this.layerManager = layerManager;
            this.selectionManager = new SelectionManager(this, this);
            this.fenceLayerFinder = new FenceLayerFinder(this);
            layerManager.addLayerListener(this);
            try {
                this.jbInit();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    WorkbenchFrame workbenchFrame = (WorkbenchFrame)SwingUtilities.getAncestorOfClass(WorkbenchFrame.class, LayerViewPanel.this);
                    if (workbenchFrame != null && !workbenchFrame.isActive()) {
                        workbenchFrame.requestFocus();
                    }
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    this.mouseLocationChanged(e);
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    this.mouseLocationChanged(e);
                }

                private void mouseLocationChanged(MouseEvent e) {
                    try {
                        Point2D p = LayerViewPanel.this.getViewport().toModelPoint(e.getPoint());
                        LayerViewPanel.this.fireCursorPositionChanged(LayerViewPanel.this.format(p.getX()), LayerViewPanel.this.format(p.getY()));
                    }
                    catch (Throwable t) {
                        LayerViewPanel.this.context.handleThrowable(t);
                    }
                }
            });
        }
        catch (Throwable t) {
            context.handleThrowable(t);
        }
    }

    public ToolTipWriter getToolTipWriter() {
        return this.toolTipWriter;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        return this.toolTipWriter.write(this.getToolTipText(), event.getPoint());
    }

    public static List components(Geometry g) {
        if (!(g instanceof GeometryCollection)) {
            return Arrays.asList(g);
        }
        GeometryCollection c = (GeometryCollection)g;
        ArrayList components = new ArrayList();
        for (int i = 0; i < c.getNumGeometries(); ++i) {
            components.addAll(LayerViewPanel.components(c.getGeometryN(i)));
        }
        return components;
    }

    public static boolean intersects(Geometry a, Geometry b) {
        GeometryFactory factory = new GeometryFactory(a.getPrecisionModel(), a.getSRID());
        List aComponents = LayerViewPanel.components(a);
        List bComponents = LayerViewPanel.components(b);
        for (Geometry aComponent : aComponents) {
            Assert.isTrue((!(aComponent instanceof GeometryCollection) ? 1 : 0) != 0);
            aComponent = LayerViewPanel.collapseToPointIfPossible(aComponent, factory);
            for (Geometry bComponent : bComponents) {
                Assert.isTrue((!(bComponent instanceof GeometryCollection) ? 1 : 0) != 0);
                if (!aComponent.intersects(bComponent = LayerViewPanel.collapseToPointIfPossible(bComponent, factory))) continue;
                return true;
            }
        }
        return false;
    }

    private static Geometry collapseToPointIfPossible(Geometry g, GeometryFactory factory) {
        if (!g.isEmpty() && PinEqualCoordinatesStyle.coordinatesEqual(g)) {
            g = factory.createPoint(g.getCoordinate());
        }
        return g;
    }

    public Map visibleLayerToFeaturesInFenceMap() {
        Map visibleLayerToFeaturesInFenceMap = this.visibleLayerToFeaturesInFenceMap(this.getFence());
        visibleLayerToFeaturesInFenceMap.remove(new FenceLayerFinder(this).getLayer());
        return visibleLayerToFeaturesInFenceMap;
    }

    public Map visibleLayerToFeaturesInFenceMap(Geometry fence) {
        HashMap map = new HashMap();
        Iterator i = this.getLayerManager().iterator();
        while (i.hasNext()) {
            Layer layer = (Layer)i.next();
            if (!layer.isVisible()) continue;
            HashSet<Feature> features = new HashSet<Feature>();
            for (Feature candidate : layer.getFeatureCollectionWrapper().query(fence.getEnvelopeInternal())) {
                if (!LayerViewPanel.intersects(candidate.getGeometry(), fence)) continue;
                features.add(candidate);
            }
            if (features.isEmpty()) continue;
            map.put(layer, features);
        }
        return map;
    }

    public static JPopupMenu popupMenu() {
        return popupMenu;
    }

    public void setCurrentCursorTool(CursorTool currentCursorTool) {
        this.currentCursorTool.deactivate();
        this.removeMouseListener(this.currentCursorTool);
        this.removeMouseMotionListener(this.currentCursorTool);
        this.currentCursorTool = currentCursorTool;
        currentCursorTool.activate(this);
        this.setCursor(currentCursorTool.getCursor());
        this.addMouseListener(currentCursorTool);
        this.addMouseMotionListener(currentCursorTool);
    }

    public void setViewportInitialized(boolean viewportInitialized) {
        this.viewportInitialized = viewportInitialized;
    }

    public CursorTool getCurrentCursorTool() {
        return this.currentCursorTool;
    }

    public Point getLastClickedPoint() {
        return this.lastClickedPoint;
    }

    public Viewport getViewport() {
        return this.viewport;
    }

    public Java2DConverter getJava2DConverter() {
        return this.viewport.getJava2DConverter();
    }

    public Geometry getFence() {
        return this.fenceLayerFinder.getFence();
    }

    @Override
    public LayerManager getLayerManager() {
        return this.layerManager;
    }

    @Override
    public void featuresChanged(FeatureEvent e) {
    }

    @Override
    public void categoryChanged(CategoryEvent e) {
    }

    @Override
    public void layerChanged(LayerEvent e) {
        try {
            if (e.getType() == LayerEventType.METADATA_CHANGED) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        LayerViewPanel.this.initializeViewportIfNecessary();
                    }
                    catch (Throwable t) {
                        LayerViewPanel.this.context.handleThrowable(t);
                    }
                }
            });
            if (e.getType() == LayerEventType.ADDED || e.getType() == LayerEventType.REMOVED || e.getType() == LayerEventType.APPEARANCE_CHANGED) {
                this.renderingManager.render(e.getLayerable());
            } else if (e.getType() == LayerEventType.VISIBILITY_CHANGED) {
                this.renderingManager.render(e.getLayerable(), false);
            } else {
                Assert.shouldNeverReachHere();
            }
        }
        catch (Throwable t) {
            this.context.handleThrowable(t);
        }
    }

    public Image createBlankPanelImage() {
        return new BufferedImage(this.getWidth(), this.getHeight(), 2);
    }

    @Override
    public void repaint() {
        if (this.renderingManager == null) {
            this.superRepaint();
            return;
        }
        this.renderingManager.renderAll();
    }

    public void superRepaint() {
        super.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        try {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            super.paintComponent(g);
            this.erase((Graphics2D)g);
            this.renderingManager.copyTo((Graphics2D)g);
            this.firePainted(g);
        }
        catch (Throwable t) {
            this.context.handleThrowable(t);
        }
    }

    public void erase(Graphics2D g) {
        this.fill(g, this.getBackground());
    }

    public void fill(Graphics2D g, Color color) {
        g.setColor(color);
        Rectangle2D.Double r = new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight());
        g.fill(r);
    }

    void jbInit() throws Exception {
        this.setBackground(Color.white);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                LayerViewPanel.this.this_mouseReleased(e);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                LayerViewPanel.this.this_componentResized(e);
            }
        });
        this.setLayout(this.borderLayout1);
    }

    void this_componentResized(ComponentEvent e) {
        try {
            this.viewport.update();
        }
        catch (Throwable t) {
            this.context.handleThrowable(t);
        }
    }

    public LayerViewPanelContext getContext() {
        return this.context;
    }

    void this_mouseReleased(MouseEvent e) {
        this.lastClickedPoint = e.getPoint();
        if (this.currentCursorTool.isRightMouseButtonUsed()) {
            return;
        }
        if (SwingUtilities.isRightMouseButton(e)) {
            if (popupMenu.getSubElements().length == 0) {
                return;
            }
            popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private void initializeViewportIfNecessary() throws NoninvertibleTransformException {
        if (!this.viewportInitialized && this.layerManager.size() > 0 && this.layerManager.getEnvelopeOfAllLayers().getWidth() > 0.0) {
            this.setViewportInitialized(true);
            this.viewport.zoomToFullExtent();
            return;
        }
    }

    public void addListener(LayerViewPanelListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(LayerViewPanelListener listener) {
        this.listeners.remove(listener);
    }

    public String format(double d) {
        double pixelWidthInModelUnits = this.viewport.getEnvelopeInModelCoordinates().getWidth() / (double)this.getWidth();
        return this.format(d, pixelWidthInModelUnits);
    }

    protected String format(double d, double pixelWidthInModelUnits) {
        int precisionInDecimalPlaces = (int)Math.max(0L, Math.round(-Math.log(pixelWidthInModelUnits) / Math.log(10.0)));
        ++precisionInDecimalPlaces;
        String formatString = "#.";
        for (int i = 0; i < precisionInDecimalPlaces; ++i) {
            formatString = formatString + "#";
        }
        return new DecimalFormat(formatString).format(d);
    }

    private void firePainted(Graphics graphics) {
        for (LayerViewPanelListener l : this.listeners) {
            l.painted(graphics);
        }
    }

    public void fireSelectionChanged() {
        for (LayerViewPanelListener l : this.listeners) {
            l.selectionChanged();
        }
    }

    private void fireCursorPositionChanged(String x, String y) {
        for (LayerViewPanelListener l : this.listeners) {
            l.cursorPositionChanged(x, y);
        }
    }

    public RenderingManager getRenderingManager() {
        return this.renderingManager;
    }

    public Collection featuresWithVertex(Point2D viewPoint, double viewTolerance, Collection features) throws NoninvertibleTransformException {
        Point2D modelPoint = this.viewport.toModelPoint(viewPoint);
        double modelTolerance = viewTolerance / this.viewport.getScale();
        Envelope searchEnvelope = new Envelope(modelPoint.getX() - modelTolerance, modelPoint.getX() + modelTolerance, modelPoint.getY() - modelTolerance, modelPoint.getY() + modelTolerance);
        ArrayList<Feature> featuresWithVertex = new ArrayList<Feature>();
        for (Feature feature : features) {
            if (!this.geometryHasVertex(feature.getGeometry(), searchEnvelope)) continue;
            featuresWithVertex.add(feature);
        }
        return featuresWithVertex;
    }

    private boolean geometryHasVertex(Geometry geometry, Envelope searchEnvelope) {
        Coordinate[] coordinates = geometry.getCoordinates();
        for (int i = 0; i < coordinates.length; ++i) {
            if (!searchEnvelope.contains(coordinates[i])) continue;
            return true;
        }
        return false;
    }

    public void dispose() {
        this.renderingManager.dispose();
        this.selectionManager.dispose();
        this.layerManager.removeLayerListener(this);
    }

    public void flash(final Shape shape, Color color, Stroke stroke, final int millisecondDelay) {
        final Graphics2D graphics = (Graphics2D)this.getGraphics();
        graphics.setColor(color);
        graphics.setXORMode(Color.white);
        graphics.setStroke(stroke);
        try {
            GUIUtil.invokeOnEventThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        graphics.draw(shape);
                        Thread.sleep(millisecondDelay);
                        graphics.draw(shape);
                    }
                    catch (Throwable t) {
                        LayerViewPanel.this.getContext().handleThrowable(t);
                    }
                }
            });
        }
        catch (Throwable t) {
            this.getContext().handleThrowable(t);
        }
    }

    @Override
    public SelectionManager getSelectionManager() {
        return this.selectionManager;
    }

    public Blackboard getBlackboard() {
        return this.blackboard;
    }

    public void flash(GeometryCollection geometryCollection) throws NoninvertibleTransformException {
        this.flash(this.getViewport().getJava2DConverter().toShape((Geometry)geometryCollection), Color.red, new BasicStroke(5.0f, 1, 1), 100);
    }
}

