/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui;

import org.locationtech.jts.jump.workbench.WorkbenchContext;
import org.locationtech.jts.jump.workbench.model.CategoryEvent;
import org.locationtech.jts.jump.workbench.model.FeatureEvent;
import org.locationtech.jts.jump.workbench.model.FeatureEventType;
import org.locationtech.jts.jump.workbench.model.Layer;
import org.locationtech.jts.jump.workbench.model.LayerEvent;
import org.locationtech.jts.jump.workbench.model.LayerListener;
import org.locationtech.jts.jump.workbench.model.LayerManagerProxy;
import org.locationtech.jts.jump.workbench.ui.AttributeTab;
import org.locationtech.jts.jump.workbench.ui.InfoModel;
import org.locationtech.jts.jump.workbench.ui.LayerTableModel;
import org.locationtech.jts.jump.workbench.ui.TaskFrame;

public class OneLayerAttributeTab
extends AttributeTab {
    public OneLayerAttributeTab(WorkbenchContext context, TaskFrame taskFrame, LayerManagerProxy layerManagerProxy) {
        super(new InfoModel(), context, taskFrame, layerManagerProxy);
        context.getLayerManager().addLayerListener(new LayerListener(){

            @Override
            public void featuresChanged(FeatureEvent e) {
                if (OneLayerAttributeTab.this.getLayerTableModel() == null) {
                    return;
                }
                if (e.getLayer() == OneLayerAttributeTab.this.getLayerTableModel().getLayer() && e.getType() == FeatureEventType.ADDED) {
                    OneLayerAttributeTab.this.getLayerTableModel().addAll(e.getFeatures());
                }
            }

            @Override
            public void layerChanged(LayerEvent e) {
            }

            @Override
            public void categoryChanged(CategoryEvent e) {
            }
        });
    }

    public OneLayerAttributeTab setLayer(Layer layer) {
        if (!this.getModel().getLayers().isEmpty()) {
            this.getModel().remove(this.getLayer());
        }
        this.getModel().add(layer, layer.getFeatureCollectionWrapper().getFeatures());
        return this;
    }

    public Layer getLayer() {
        return this.getLayerTableModel() != null ? this.getLayerTableModel().getLayer() : null;
    }

    public LayerTableModel getLayerTableModel() {
        return !this.getModel().getLayerTableModels().isEmpty() ? (LayerTableModel)this.getModel().getLayerTableModels().iterator().next() : null;
    }
}

