/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.jump.workbench.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.jump.feature.Feature;
import org.locationtech.jts.jump.workbench.model.Layer;
import org.locationtech.jts.jump.workbench.ui.AbstractSelection;
import org.locationtech.jts.jump.workbench.ui.FeatureSelection;
import org.locationtech.jts.jump.workbench.ui.LineStringSelection;
import org.locationtech.jts.jump.workbench.ui.SelectionManager;
import org.locationtech.jts.util.Assert;

public class PartSelection
extends AbstractSelection {
    @Override
    public List items(Geometry geometry) {
        ArrayList<Geometry> items = new ArrayList<Geometry>();
        if (geometry instanceof GeometryCollection) {
            for (int i = 0; i < ((GeometryCollection)geometry).getNumGeometries(); ++i) {
                items.addAll(this.items(((GeometryCollection)geometry).getGeometryN(i)));
            }
        } else {
            items.add(geometry);
        }
        return items;
    }

    public PartSelection(SelectionManager selectionManager) {
        super(selectionManager);
    }

    @Override
    public String getRendererContentID() {
        return "SELECTED_PARTS";
    }

    @Override
    protected boolean selectedInAncestors(Layer layer, Feature feature, Geometry item) {
        Assert.isTrue((boolean)(this.getParent() instanceof FeatureSelection));
        return this.getParent().getFeaturesWithSelectedItems().contains(feature);
    }

    @Override
    protected void unselectInDescendants(Layer layer, Feature feature, Collection items) {
        Assert.isTrue((boolean)(this.getChild() instanceof LineStringSelection));
        for (Geometry part : items) {
            List partLineStrings = this.getChild().items(part);
            for (LineString selectedLineString : this.getChild().getSelectedItems(layer, feature)) {
                if (!partLineStrings.contains(selectedLineString)) continue;
                this.getChild().unselectItem(layer, feature, partLineStrings.indexOf(selectedLineString));
            }
        }
    }
}

